(function() {
  var CompositeDisposable, Disposable, ResultsPaneView, ResultsView, ScrollView, Util, _, _ref,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  _ = require('underscore-plus');

  ScrollView = require('atom-space-pen-views').ScrollView;

  _ref = require('atom'), Disposable = _ref.Disposable, CompositeDisposable = _ref.CompositeDisposable;

  ResultsView = require('./results-view');

  Util = require('./util');

  module.exports = ResultsPaneView = (function(_super) {
    __extends(ResultsPaneView, _super);

    function ResultsPaneView() {
      this.onCleared = __bind(this.onCleared, this);
      this.onReplacementStateCleared = __bind(this.onReplacementStateCleared, this);
      this.onFinishedSearching = __bind(this.onFinishedSearching, this);
      this.onPathsSearched = __bind(this.onPathsSearched, this);
      this.onSearch = __bind(this.onSearch, this);
      this.focused = __bind(this.focused, this);
      return ResultsPaneView.__super__.constructor.apply(this, arguments);
    }

    ResultsPaneView.URI = "atom://find-and-replace/project-results";

    ResultsPaneView.content = function() {
      return this.div({
        "class": 'preview-pane pane-item',
        tabindex: -1
      }, (function(_this) {
        return function() {
          _this.div({
            "class": 'panel-heading'
          }, function() {
            _this.span({
              outlet: 'previewCount',
              "class": 'preview-count inline-block'
            });
            return _this.div({
              outlet: 'loadingMessage',
              "class": 'inline-block'
            }, function() {
              _this.div({
                "class": 'loading loading-spinner-tiny inline-block'
              });
              return _this.div({
                outlet: 'searchedCountBlock',
                "class": 'inline-block'
              }, function() {
                _this.span({
                  outlet: 'searchedCount',
                  "class": 'searched-count'
                });
                return _this.span(' paths searched');
              });
            });
          });
          _this.ul({
            outlet: 'errorList',
            "class": 'error-list list-group padded'
          });
          _this.subview('resultsView', new ResultsView(_this.model));
          return _this.ul({
            "class": 'centered background-message no-results-overlay'
          }, function() {
            return _this.li('No Results');
          });
        };
      })(this));
    };

    ResultsPaneView.prototype.initialize = function() {
      ResultsPaneView.__super__.initialize.apply(this, arguments);
      this.loadingMessage.hide();
      this.model = this.constructor.model;
      this.onFinishedSearching(this.model.getResultsSummary());
      return this.on('focus', this.focused);
    };

    ResultsPaneView.prototype.attached = function() {
      this.model.setActive(true);
      this.subscriptions = new CompositeDisposable;
      return this.handleEvents();
    };

    ResultsPaneView.prototype.detached = function() {
      this.model.setActive(false);
      return this.subscriptions.dispose();
    };

    ResultsPaneView.prototype.copy = function() {
      return new ResultsPaneView();
    };

    ResultsPaneView.prototype.getPaneView = function() {
      return this.parents('.pane').view();
    };

    ResultsPaneView.prototype.getTitle = function() {
      return "Project Find Results";
    };

    ResultsPaneView.prototype.onDidChangeTitle = function() {
      return new Disposable();
    };

    ResultsPaneView.prototype.onDidChangeModified = function() {
      return new Disposable();
    };

    ResultsPaneView.prototype.getIconName = function() {
      return "search";
    };

    ResultsPaneView.prototype.getURI = function() {
      return this.constructor.URI;
    };

    ResultsPaneView.prototype.focused = function() {
      return this.resultsView.focus();
    };

    ResultsPaneView.prototype.handleEvents = function() {
      this.subscriptions.add(this.model.onDidStartSearching(this.onSearch));
      this.subscriptions.add(this.model.onDidFinishSearching(this.onFinishedSearching));
      this.subscriptions.add(this.model.onDidClear(this.onCleared));
      this.subscriptions.add(this.model.onDidClearReplacementState(this.onReplacementStateCleared));
      this.subscriptions.add(this.model.onDidSearchPaths(this.onPathsSearched));
      return this.subscriptions.add(this.model.onDidErrorForPath((function(_this) {
        return function(error) {
          return _this.appendError(error.message);
        };
      })(this)));
    };

    ResultsPaneView.prototype.setErrors = function(messages) {
      var message, _i, _len;
      if ((messages != null) && messages.length) {
        this.errorList.html('');
        for (_i = 0, _len = messages.length; _i < _len; _i++) {
          message = messages[_i];
          this.appendError(message);
        }
      } else {
        this.clearErrors();
      }
    };

    ResultsPaneView.prototype.appendError = function(message) {
      this.errorList.append("<li class=\"text-error\">" + (Util.escapeHtml(message)) + "</li>");
      return this.errorList.show();
    };

    ResultsPaneView.prototype.clearErrors = function() {
      return this.errorList.html('').hide();
    };

    ResultsPaneView.prototype.onSearch = function(deferred) {
      var timeout;
      this.loadingMessage.show();
      this.previewCount.text('Searching...');
      this.searchedCount.text('0');
      this.searchedCountBlock.hide();
      this.removeClass('no-results');
      this.previewCount.show();
      this.showSearchedCountBlock = false;
      timeout = setTimeout((function(_this) {
        return function() {
          _this.searchedCountBlock.show();
          return _this.showSearchedCountBlock = true;
        };
      })(this), 500);
      return deferred.done((function(_this) {
        return function() {
          return _this.loadingMessage.hide();
        };
      })(this));
    };

    ResultsPaneView.prototype.onPathsSearched = function(numberOfPathsSearched) {
      if (this.showSearchedCountBlock) {
        return this.searchedCount.text(numberOfPathsSearched);
      }
    };

    ResultsPaneView.prototype.onFinishedSearching = function(results) {
      var errors;
      this.hideOrShowNoResults(results);
      this.previewCount.html(Util.getSearchResultsMessage(results));
      if ((results.searchErrors != null) || (results.replacementErrors != null)) {
        errors = _.pluck(results.replacementErrors, 'message');
        errors = errors.concat(_.pluck(results.searchErrors, 'message'));
        return this.setErrors(errors);
      } else {
        return this.clearErrors();
      }
    };

    ResultsPaneView.prototype.onReplacementStateCleared = function(results) {
      this.hideOrShowNoResults(results);
      this.previewCount.html(Util.getSearchResultsMessage(results));
      return this.clearErrors();
    };

    ResultsPaneView.prototype.onCleared = function() {
      this.addClass('no-results');
      this.previewCount.text('Find in project results');
      this.loadingMessage.hide();
      return this.searchedCountBlock.hide();
    };

    ResultsPaneView.prototype.hideOrShowNoResults = function(results) {
      if (results.pathCount) {
        return this.removeClass('no-results');
      } else {
        return this.addClass('no-results');
      }
    };

    return ResultsPaneView;

  })(ScrollView);

}).call(this);
