(function() {
  var $, CompositeDisposable, ResultView, ResultsView, ScrollView, _, _ref,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  _ = require('underscore-plus');

  CompositeDisposable = require('atom').CompositeDisposable;

  _ref = require('atom-space-pen-views'), $ = _ref.$, ScrollView = _ref.ScrollView;

  ResultView = require('./result-view');

  module.exports = ResultsView = (function(_super) {
    __extends(ResultsView, _super);

    function ResultsView() {
      this.clear = __bind(this.clear, this);
      this.removeResult = __bind(this.removeResult, this);
      this.addResult = __bind(this.addResult, this);
      return ResultsView.__super__.constructor.apply(this, arguments);
    }

    ResultsView.content = function() {
      return this.ol({
        "class": 'results-view list-tree focusable-panel has-collapsable-children',
        tabindex: -1
      });
    };

    ResultsView.prototype.initialize = function(model) {
      var commandsDisposable;
      this.model = model;
      commandsDisposable = ResultsView.__super__.initialize.call(this);
      commandsDisposable.dispose();
      this.pixelOverdraw = 100;
      this.lastRenderedResultIndex = 0;
      this.on('mousedown', '.match-result, .path', (function(_this) {
        return function(_arg) {
          var ctrlKey, target, view, which;
          target = _arg.target, which = _arg.which, ctrlKey = _arg.ctrlKey;
          _this.find('.selected').removeClass('selected');
          view = $(target).view();
          view.addClass('selected');
          if (which === 1 && !ctrlKey) {
            view.confirm();
          }
          return _this.renderResults();
        };
      })(this));
      this.on('scroll', (function(_this) {
        return function() {
          return _this.renderResults();
        };
      })(this));
      return this.on('resize', (function(_this) {
        return function() {
          return _this.renderResults();
        };
      })(this));
    };

    ResultsView.prototype.attached = function() {
      this.subscriptions = new CompositeDisposable;
      this.subscriptions.add(atom.commands.add(this.element, {
        'core:move-down': (function(_this) {
          return function() {
            return _this.selectNextResult();
          };
        })(this),
        'core:move-up': (function(_this) {
          return function() {
            return _this.selectPreviousResult();
          };
        })(this),
        'core:move-left': (function(_this) {
          return function() {
            return _this.collapseResult();
          };
        })(this),
        'core:move-right': (function(_this) {
          return function() {
            return _this.expandResult();
          };
        })(this),
        'core:confirm': (function(_this) {
          return function() {
            var _ref1;
            if ((_ref1 = _this.find('.selected').view()) != null) {
              if (typeof _ref1.confirm === "function") {
                _ref1.confirm();
              }
            }
            return false;
          };
        })(this),
        'core:copy': (function(_this) {
          return function() {
            var _ref1;
            if ((_ref1 = _this.find('.selected').view()) != null) {
              if (typeof _ref1.copy === "function") {
                _ref1.copy();
              }
            }
            return false;
          };
        })(this)
      }));
      this.subscriptions.add(this.model.onDidAddResult(this.addResult));
      this.subscriptions.add(this.model.onDidRemoveResult(this.removeResult));
      this.subscriptions.add(this.model.onDidClearSearchState(this.clear));
      return this.renderResults();
    };

    ResultsView.prototype.detached = function() {
      this.clear();
      return this.subscriptions.dispose();
    };

    ResultsView.prototype.hasResults = function() {
      return this.model.getResultCount() > 0;
    };

    ResultsView.prototype.addResult = function(_arg) {
      var filePath, result, resultView;
      filePath = _arg.filePath, result = _arg.result;
      resultView = this.getResultView(filePath);
      if (resultView) {
        return resultView.renderResult(result);
      } else {
        this.renderResults();
        if (this.getPathCount() === 1) {
          return this.selectFirstResult();
        }
      }
    };

    ResultsView.prototype.removeResult = function(_arg) {
      var filePath, resultView;
      filePath = _arg.filePath;
      resultView = this.getResultView(filePath);
      if (resultView) {
        return resultView.renderResult(null);
      }
    };

    ResultsView.prototype.renderResults = function(_arg) {
      var filePath, paths, renderAll, result, resultView, _i, _len, _ref1;
      renderAll = (_arg != null ? _arg : {}).renderAll;
      if (!(renderAll || this.shouldRenderMoreResults())) {
        return;
      }
      paths = this.model.getPaths();
      _ref1 = paths.slice(this.lastRenderedResultIndex);
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        filePath = _ref1[_i];
        result = this.model.getResult(filePath);
        if (!renderAll && !this.shouldRenderMoreResults()) {
          break;
        }
        resultView = new ResultView(this.model, filePath, result);
        this.append(resultView);
        this.lastRenderedResultIndex++;
      }
      return null;
    };

    ResultsView.prototype.shouldRenderMoreResults = function() {
      return this.prop('scrollHeight') <= this.height() + this.pixelOverdraw || this.prop('scrollHeight') <= this.scrollBottom() + this.pixelOverdraw;
    };

    ResultsView.prototype.selectFirstResult = function() {
      return this.find('.search-result:first').addClass('selected');
    };

    ResultsView.prototype.selectNextResult = function() {
      var nextParent, nextView, selectedView;
      selectedView = this.find('.selected').view();
      if (!selectedView) {
        return this.selectFirstResult();
      }
      if (selectedView.isExpanded) {
        nextView = selectedView.find('.search-result:first').view();
      } else {
        nextView = selectedView.next().view();
        if (nextView == null) {
          nextParent = selectedView.closest('.path').next();
          nextView = !nextParent.hasClass('collapsed') ? nextParent.find('.search-result:first').view() : nextParent.view();
        } else if (nextView.isExpanded) {
          nextView = nextView.find('.search-result:first').view();
        }
      }
      if (nextView != null) {
        selectedView.removeClass('selected');
        nextView.addClass('selected');
        return this.scrollTo(nextView);
      }
    };

    ResultsView.prototype.selectPreviousResult = function() {
      var prevParent, prevView, selectedView;
      selectedView = this.find('.selected').view();
      if (!selectedView) {
        return this.selectFirstResult();
      }
      if (selectedView.isExpanded) {
        prevView = selectedView.find('.search-result:last').view();
      } else {
        prevView = selectedView.prev().view();
        if (prevView == null) {
          prevParent = selectedView.closest('.path').prev();
          prevView = !prevParent.hasClass('collapsed') ? prevParent.find('.search-result:last').view() : prevParent.view();
        } else if (prevView.isExpanded) {
          prevView = prevView.find('.search-result:last').view();
        }
      }
      if (prevView != null) {
        selectedView.removeClass('selected');
        prevView.addClass('selected');
        return this.scrollTo(prevView);
      }
    };

    ResultsView.prototype.collapseResult = function() {
      var parent;
      parent = this.find('.selected').closest('.path').view();
      if (parent instanceof ResultView) {
        parent.expand(false);
      }
      return this.renderResults();
    };

    ResultsView.prototype.expandResult = function() {
      var selectedView;
      selectedView = this.find('.selected').view();
      if (selectedView instanceof ResultView) {
        selectedView.expand(true);
      }
      return this.renderResults();
    };

    ResultsView.prototype.getPathCount = function() {
      return this.model.getPathCount();
    };

    ResultsView.prototype.getMatchCount = function() {
      return this.model.getMatchCount();
    };

    ResultsView.prototype.clear = function() {
      this.lastRenderedResultIndex = 0;
      return this.empty();
    };

    ResultsView.prototype.scrollTo = function(element) {
      var bottom, top;
      top = this.scrollTop() + element.offset().top - this.offset().top;
      bottom = top + element.outerHeight();
      if (bottom > this.scrollBottom()) {
        this.scrollBottom(bottom);
      }
      if (top < this.scrollTop()) {
        return this.scrollTop(top);
      }
    };

    ResultsView.prototype.scrollToBottom = function() {
      var lastPath;
      this.renderResults({
        renderAll: true
      });
      ResultsView.__super__.scrollToBottom.call(this);
      this.find('.selected').removeClass('selected');
      lastPath = this.find('.path:last');
      return lastPath.find('.search-result:last').addClass('selected');
    };

    ResultsView.prototype.scrollToTop = function() {
      ResultsView.__super__.scrollToTop.call(this);
      this.find('.selected').removeClass('selected');
      return this.find('.path:first').addClass('selected');
    };

    ResultsView.prototype.getResultView = function(filePath) {
      var el;
      el = this.find("[data-path=\"" + (_.escapeAttribute(filePath)) + "\"]");
      if (el.length) {
        return el.view();
      } else {
        return null;
      }
    };

    return ResultsView;

  })(ScrollView);

}).call(this);
