(function() {
  var _;

  _ = require('underscore-plus');

  module.exports = {
    escapeHtml: function(str) {
      if (this.escapeNode == null) {
        this.escapeNode = document.createElement('div');
      }
      this.escapeNode.innerText = str;
      return this.escapeNode.innerHTML;
    },
    sanitizePattern: function(pattern) {
      pattern = this.escapeHtml(pattern);
      return pattern.replace(/\n/g, '\\n').replace(/\t/g, '\\t');
    },
    getReplacementResultsMessage: function(_arg) {
      var pattern, replacedPathCount, replacementCount, replacementPattern;
      pattern = _arg.pattern, replacementPattern = _arg.replacementPattern, replacedPathCount = _arg.replacedPathCount, replacementCount = _arg.replacementCount;
      if (replacedPathCount) {
        return "<span class=\"text-highlight\">Replaced <span class=\"highlight-error\">" + (this.sanitizePattern(pattern)) + "</span> with <span class=\"highlight-success\">" + (this.sanitizePattern(replacementPattern)) + "</span> " + (_.pluralize(replacementCount, 'time')) + " in " + (_.pluralize(replacedPathCount, 'file')) + "</span>";
      } else {
        return "<span class=\"text-highlight\">Nothing replaced</span>";
      }
    },
    getSearchResultsMessage: function(_arg) {
      var matchCount, pathCount, pattern, replacedPathCount;
      pattern = _arg.pattern, matchCount = _arg.matchCount, pathCount = _arg.pathCount, replacedPathCount = _arg.replacedPathCount;
      if (matchCount) {
        return "" + (_.pluralize(matchCount, 'result')) + " found in " + (_.pluralize(pathCount, 'file')) + " for <span class=\"highlight-info\">" + (this.sanitizePattern(pattern)) + "</span>";
      } else {
        return "No " + (replacedPathCount != null ? 'more' : '') + " results found for '" + (this.sanitizePattern(pattern)) + "'";
      }
    }
  };

}).call(this);
