(function() {
  var ResultsModel, path, waitsForPromise;

  path = require('path');

  ResultsModel = require('../lib/project/results-model');

  waitsForPromise = function(fn) {
    return window.waitsForPromise({
      timeout: 30000
    }, fn);
  };

  describe('ResultsModel', function() {
    var editor, resultsModel, searchPromise, _ref;
    _ref = [], editor = _ref[0], searchPromise = _ref[1], resultsModel = _ref[2], searchPromise = _ref[3];
    beforeEach(function() {
      atom.project.setPaths([path.join(__dirname, 'fixtures')]);
      waitsForPromise(function() {
        return atom.workspace.open('sample.js');
      });
      return runs(function() {
        editor = atom.workspace.getActiveTextEditor();
        return resultsModel = new ResultsModel();
      });
    });
    describe("searching for a pattern", function() {
      beforeEach(function() {});
      it("populates the model with all the results, and updates in response to changes in the buffer", function() {
        var resultAddedSpy, resultRemovedSpy;
        resultAddedSpy = jasmine.createSpy();
        resultRemovedSpy = jasmine.createSpy();
        runs(function() {
          resultsModel.onDidAddResult(resultAddedSpy);
          resultsModel.onDidRemoveResult(resultRemovedSpy);
          return searchPromise = resultsModel.search('items', ['*.js'], '');
        });
        waitsForPromise(function() {
          return searchPromise;
        });
        return runs(function() {
          var result;
          expect(resultAddedSpy).toHaveBeenCalled();
          expect(resultAddedSpy.callCount).toBe(1);
          result = resultsModel.getResult(editor.getPath());
          expect(result.matches.length).toBe(6);
          expect(resultsModel.getPathCount()).toBe(1);
          expect(resultsModel.getMatchCount()).toBe(6);
          expect(resultsModel.getPaths()).toEqual([editor.getPath()]);
          editor.setText('there are some items in here');
          advanceClock(editor.buffer.stoppedChangingDelay);
          expect(resultAddedSpy.callCount).toBe(2);
          result = resultsModel.getResult(editor.getPath());
          expect(result.matches.length).toBe(1);
          expect(resultsModel.getPathCount()).toBe(1);
          expect(resultsModel.getMatchCount()).toBe(1);
          expect(resultsModel.getPaths()).toEqual([editor.getPath()]);
          expect(result.matches[0].lineText).toBe('there are some items in here');
          editor.setText('no matches in here');
          advanceClock(editor.buffer.stoppedChangingDelay);
          expect(resultAddedSpy.callCount).toBe(2);
          expect(resultRemovedSpy.callCount).toBe(1);
          result = resultsModel.getResult(editor.getPath());
          expect(result).not.toBeDefined();
          expect(resultsModel.getPathCount()).toBe(0);
          expect(resultsModel.getMatchCount()).toBe(0);
          resultsModel.clear();
          spyOn(editor, 'scan').andCallThrough();
          editor.setText('no matches in here');
          advanceClock(editor.buffer.stoppedChangingDelay);
          expect(editor.scan).not.toHaveBeenCalled();
          expect(resultsModel.getPathCount()).toBe(0);
          return expect(resultsModel.getMatchCount()).toBe(0);
        });
      });
      return it("ignores changes in untitled buffers", function() {
        var resultAddedSpy, resultRemovedSpy;
        resultAddedSpy = jasmine.createSpy();
        resultRemovedSpy = jasmine.createSpy();
        waitsForPromise(function() {
          return atom.workspace.open();
        });
        runs(function() {
          resultsModel.onDidAddResult(resultAddedSpy);
          resultsModel.onDidRemoveResult(resultRemovedSpy);
          return searchPromise = resultsModel.search('items', ['*.js'], '');
        });
        waitsForPromise(function() {
          return searchPromise;
        });
        return runs(function() {
          editor = atom.workspace.getActiveTextEditor();
          editor.setText('items\nitems');
          spyOn(editor, 'scan').andCallThrough();
          advanceClock(editor.buffer.stoppedChangingDelay);
          return expect(editor.scan).not.toHaveBeenCalled();
        });
      });
    });
    return describe("cancelling a search", function() {
      var cancelledSpy;
      cancelledSpy = null;
      beforeEach(function() {
        cancelledSpy = jasmine.createSpy();
        return resultsModel.onDidCancelSearching(cancelledSpy);
      });
      it("populates the model with all the results, and updates in response to changes in the buffer", function() {
        runs(function() {
          searchPromise = resultsModel.search('items', ['*.js'], '');
          expect(resultsModel.inProgressSearchPromise).toBeTruthy();
          resultsModel.clear();
          return expect(resultsModel.inProgressSearchPromise).toBeFalsy();
        });
        waitsForPromise(function() {
          return searchPromise;
        });
        return runs(function() {
          return expect(cancelledSpy).toHaveBeenCalled();
        });
      });
      return it("populates the model with all the results, and updates in response to changes in the buffer", function() {
        runs(function() {
          searchPromise = resultsModel.search('items', ['*.js'], '');
          return searchPromise = resultsModel.search('sort', ['*.js'], '');
        });
        waitsForPromise(function() {
          return searchPromise;
        });
        return runs(function() {
          expect(cancelledSpy).toHaveBeenCalled();
          expect(resultsModel.getPathCount()).toBe(1);
          return expect(resultsModel.getMatchCount()).toBe(5);
        });
      });
    });
  });

}).call(this);
