(function() {
  var $$, DiffListView, SelectListView, repositoryForPath, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  _ref = require('atom-space-pen-views'), $$ = _ref.$$, SelectListView = _ref.SelectListView;

  repositoryForPath = require('./helpers').repositoryForPath;

  module.exports = DiffListView = (function(_super) {
    __extends(DiffListView, _super);

    function DiffListView() {
      return DiffListView.__super__.constructor.apply(this, arguments);
    }

    DiffListView.prototype.initialize = function() {
      DiffListView.__super__.initialize.apply(this, arguments);
      this.panel = atom.workspace.addModalPanel({
        item: this,
        visible: false
      });
      return this.addClass('diff-list-view');
    };

    DiffListView.prototype.getEmptyMessage = function(itemCount) {
      if (itemCount === 0) {
        return 'No diffs in file';
      } else {
        return DiffListView.__super__.getEmptyMessage.apply(this, arguments);
      }
    };

    DiffListView.prototype.getFilterKey = function() {
      return 'lineText';
    };

    DiffListView.prototype.attach = function() {
      this.storeFocusedElement();
      this.panel.show();
      return this.focusFilterEditor();
    };

    DiffListView.prototype.viewForItem = function(_arg) {
      var lineText, newLines, newStart, oldLines, oldStart;
      oldStart = _arg.oldStart, newStart = _arg.newStart, oldLines = _arg.oldLines, newLines = _arg.newLines, lineText = _arg.lineText;
      return $$(function() {
        return this.li({
          "class": 'two-lines'
        }, (function(_this) {
          return function() {
            _this.div(lineText, {
              "class": 'primary-line'
            });
            return _this.div("-" + oldStart + "," + oldLines + " +" + newStart + "," + newLines, {
              "class": 'secondary-line'
            });
          };
        })(this));
      });
    };

    DiffListView.prototype.populate = function() {
      var bufferRow, diff, diffs, _i, _len, _ref1, _ref2, _ref3, _ref4;
      diffs = (_ref1 = (_ref2 = repositoryForPath(this.editor.getPath())) != null ? _ref2.getLineDiffs(this.editor.getPath(), this.editor.getText()) : void 0) != null ? _ref1 : [];
      for (_i = 0, _len = diffs.length; _i < _len; _i++) {
        diff = diffs[_i];
        bufferRow = diff.newStart > 0 ? diff.newStart - 1 : diff.newStart;
        diff.lineText = (_ref3 = (_ref4 = this.editor.lineTextForBufferRow(bufferRow)) != null ? _ref4.trim() : void 0) != null ? _ref3 : '';
      }
      return this.setItems(diffs);
    };

    DiffListView.prototype.toggle = function() {
      if (this.panel.isVisible()) {
        return this.cancel();
      } else if (this.editor = atom.workspace.getActiveTextEditor()) {
        this.populate();
        return this.attach();
      }
    };

    DiffListView.prototype.cancelled = function() {
      return this.panel.hide();
    };

    DiffListView.prototype.confirmed = function(_arg) {
      var bufferRow, newStart;
      newStart = _arg.newStart;
      this.cancel();
      bufferRow = newStart > 0 ? newStart - 1 : newStart;
      this.editor.setCursorBufferPosition([bufferRow, 0], {
        autoscroll: true
      });
      return this.editor.moveToFirstCharacterOfLine();
    };

    return DiffListView;

  })(SelectListView);

}).call(this);
