(function() {
  var DiffListView, GitDiffView, diffListView, toggleDiffList;

  GitDiffView = require('./git-diff-view');

  DiffListView = null;

  diffListView = null;

  toggleDiffList = function() {
    if (DiffListView == null) {
      DiffListView = require('./diff-list-view');
    }
    if (diffListView == null) {
      diffListView = new DiffListView();
    }
    return diffListView.toggle();
  };

  module.exports = {
    config: {
      showIconsInEditorGutter: {
        type: 'boolean',
        "default": false
      }
    },
    activate: function() {
      return atom.workspace.observeTextEditors(function(editor) {
        new GitDiffView(editor);
        return atom.commands.add(atom.views.getView(editor), 'git-diff:toggle-diff-list', toggleDiffList);
      });
    },
    deactivate: function() {
      if (diffListView != null) {
        diffListView.cancel();
      }
      return diffListView = null;
    }
  };

}).call(this);
