(function() {
  var $, fs, path, temp;

  path = require('path');

  fs = require('fs-plus');

  temp = require('temp');

  $ = require('atom-space-pen-views').$;

  describe("git-diff:toggle-diff-list", function() {
    var diffListView, editor, _ref;
    _ref = [], diffListView = _ref[0], editor = _ref[1];
    beforeEach(function() {
      var projectPath;
      projectPath = temp.mkdirSync('git-diff-spec-');
      fs.copySync(path.join(__dirname, 'fixtures', 'working-dir'), projectPath);
      fs.moveSync(path.join(projectPath, 'git.git'), path.join(projectPath, '.git'));
      atom.project.setPaths([projectPath]);
      jasmine.attachToDOM(atom.views.getView(atom.workspace));
      waitsForPromise(function() {
        return atom.packages.activatePackage('git-diff');
      });
      waitsForPromise(function() {
        return atom.workspace.open('sample.js');
      });
      return runs(function() {
        editor = atom.workspace.getActiveTextEditor();
        editor.setCursorBufferPosition([4, 29]);
        editor.insertText('a');
        return atom.commands.dispatch(atom.views.getView(editor), 'git-diff:toggle-diff-list');
      });
    });
    afterEach(function() {
      return diffListView.cancel();
    });
    it("shows a list of all diff hunks", function() {
      diffListView = $(atom.views.getView(atom.workspace)).find('.diff-list-view').view();
      return expect(diffListView.list.children().text()).toBe("while(items.length > 0) {a-5,1 +5,1");
    });
    return it("moves the cursor to the selected hunk", function() {
      editor.setCursorBufferPosition([0, 0]);
      diffListView = $(atom.views.getView(atom.workspace)).find('.diff-list-view').view();
      atom.commands.dispatch(diffListView.element, 'core:confirm');
      return expect(editor.getCursorBufferPosition()).toEqual([4, 4]);
    });
  });

}).call(this);
