(function() {
  var $, GoToLineView, Point, TextEditorView, View, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  Point = require('atom').Point;

  _ref = require('atom-space-pen-views'), $ = _ref.$, TextEditorView = _ref.TextEditorView, View = _ref.View;

  module.exports = GoToLineView = (function(_super) {
    __extends(GoToLineView, _super);

    function GoToLineView() {
      return GoToLineView.__super__.constructor.apply(this, arguments);
    }

    GoToLineView.activate = function() {
      return new GoToLineView;
    };

    GoToLineView.content = function() {
      return this.div({
        "class": 'go-to-line'
      }, (function(_this) {
        return function() {
          _this.subview('miniEditor', new TextEditorView({
            mini: true
          }));
          return _this.div({
            "class": 'message',
            outlet: 'message'
          });
        };
      })(this));
    };

    GoToLineView.prototype.initialize = function() {
      this.panel = atom.workspace.addModalPanel({
        item: this,
        visible: false
      });
      atom.commands.add('atom-text-editor', 'go-to-line:toggle', (function(_this) {
        return function() {
          _this.toggle();
          return false;
        };
      })(this));
      this.miniEditor.on('blur', (function(_this) {
        return function() {
          return _this.close();
        };
      })(this));
      atom.commands.add(this.miniEditor.element, 'core:confirm', (function(_this) {
        return function() {
          return _this.confirm();
        };
      })(this));
      atom.commands.add(this.miniEditor.element, 'core:cancel', (function(_this) {
        return function() {
          return _this.close();
        };
      })(this));
      return this.miniEditor.getModel().onWillInsertText((function(_this) {
        return function(_arg) {
          var cancel, text;
          cancel = _arg.cancel, text = _arg.text;
          if (!text.match(/[0-9:]/)) {
            return cancel();
          }
        };
      })(this));
    };

    GoToLineView.prototype.toggle = function() {
      if (this.panel.isVisible()) {
        return this.close();
      } else {
        return this.open();
      }
    };

    GoToLineView.prototype.close = function() {
      var miniEditorFocused;
      if (!this.panel.isVisible()) {
        return;
      }
      miniEditorFocused = this.miniEditor.hasFocus();
      this.miniEditor.setText('');
      this.panel.hide();
      if (miniEditorFocused) {
        return this.restoreFocus();
      }
    };

    GoToLineView.prototype.confirm = function() {
      var column, currentRow, editor, lineNumber, position, row, _ref1;
      lineNumber = this.miniEditor.getText();
      editor = atom.workspace.getActiveTextEditor();
      this.close();
      if (!((editor != null) && lineNumber.length)) {
        return;
      }
      currentRow = editor.getCursorBufferPosition().row;
      _ref1 = lineNumber.split(/:+/), row = _ref1[0], column = _ref1[1];
      if ((row != null ? row.length : void 0) > 0) {
        row = parseInt(row) - 1;
      } else {
        row = currentRow;
      }
      if ((column != null ? column.length : void 0) > 0) {
        column = parseInt(column) - 1;
      } else {
        column = -1;
      }
      position = new Point(row, column);
      editor.scrollToBufferPosition(position, {
        center: true
      });
      editor.setCursorBufferPosition(position);
      if (column < 0) {
        return editor.moveToFirstCharacterOfLine();
      }
    };

    GoToLineView.prototype.storeFocusedElement = function() {
      return this.previouslyFocusedElement = $(':focus');
    };

    GoToLineView.prototype.restoreFocus = function() {
      var _ref1;
      if ((_ref1 = this.previouslyFocusedElement) != null ? _ref1.isOnDom() : void 0) {
        return this.previouslyFocusedElement.focus();
      } else {
        return atom.views.getView(atom.workspace).focus();
      }
    };

    GoToLineView.prototype.open = function() {
      var editor;
      if (this.panel.isVisible()) {
        return;
      }
      if (editor = atom.workspace.getActiveTextEditor()) {
        this.storeFocusedElement();
        this.panel.show();
        this.message.text("Enter a line row:column to go to");
        return this.miniEditor.focus();
      }
    };

    return GoToLineView;

  })(View);

}).call(this);
