(function() {
  var GoToLineView;

  GoToLineView = require('../lib/go-to-line-view');

  describe('GoToLine', function() {
    var editor, editorView, goToLine, _ref;
    _ref = [], goToLine = _ref[0], editor = _ref[1], editorView = _ref[2];
    beforeEach(function() {
      waitsForPromise(function() {
        return atom.workspace.open('sample.js');
      });
      return runs(function() {
        editor = atom.workspace.getActiveTextEditor();
        editorView = atom.views.getView(editor);
        goToLine = GoToLineView.activate();
        return editor.setCursorBufferPosition([1, 0]);
      });
    });
    describe("when go-to-line:toggle is triggered", function() {
      return it("adds a modal panel", function() {
        expect(goToLine.panel.isVisible()).toBeFalsy();
        atom.commands.dispatch(editorView, 'go-to-line:toggle');
        return expect(goToLine.panel.isVisible()).toBeTruthy();
      });
    });
    describe("when entering a line number", function() {
      return it("only allows 0-9 and the colon character to be entered in the mini editor", function() {
        expect(goToLine.miniEditor.getText()).toBe('');
        goToLine.miniEditor.getModel().insertText('a');
        expect(goToLine.miniEditor.getText()).toBe('');
        goToLine.miniEditor.getModel().insertText(':');
        expect(goToLine.miniEditor.getText()).toBe(':');
        goToLine.miniEditor.getModel().setText('');
        goToLine.miniEditor.getModel().insertText('4');
        return expect(goToLine.miniEditor.getText()).toBe('4');
      });
    });
    describe("when entering a line number and column number", function() {
      return it("moves the cursor to the column number of the line specified", function() {
        expect(goToLine.miniEditor.getText()).toBe('');
        goToLine.miniEditor.getModel().insertText('3:14');
        atom.commands.dispatch(goToLine.miniEditor.element, 'core:confirm');
        return expect(editor.getCursorBufferPosition()).toEqual([2, 13]);
      });
    });
    describe("when entering a line number greater than the number in the buffer", function() {
      return it("moves the cursor position to the first character of the last line", function() {
        atom.commands.dispatch(editorView, 'go-to-line:toggle');
        expect(goToLine.panel.isVisible()).toBeTruthy();
        expect(goToLine.miniEditor.getText()).toBe('');
        goToLine.miniEditor.getModel().insertText('14');
        atom.commands.dispatch(goToLine.miniEditor.element, 'core:confirm');
        expect(goToLine.panel.isVisible()).toBeFalsy();
        return expect(editor.getCursorBufferPosition()).toEqual([12, 0]);
      });
    });
    describe("when entering a column number greater than the number in the specified line", function() {
      return it("moves the cursor position to the last character of the specified line", function() {
        atom.commands.dispatch(editorView, 'go-to-line:toggle');
        expect(goToLine.panel.isVisible()).toBeTruthy();
        expect(goToLine.miniEditor.getText()).toBe('');
        goToLine.miniEditor.getModel().insertText('3:43');
        atom.commands.dispatch(goToLine.miniEditor.element, 'core:confirm');
        expect(goToLine.panel.isVisible()).toBeFalsy();
        return expect(editor.getCursorBufferPosition()).toEqual([2, 40]);
      });
    });
    describe("when core:confirm is triggered", function() {
      return describe("when a line number has been entered", function() {
        return it("moves the cursor to the first character of the line", function() {
          goToLine.miniEditor.getModel().insertText('3');
          atom.commands.dispatch(goToLine.miniEditor.element, 'core:confirm');
          return expect(editor.getCursorBufferPosition()).toEqual([2, 4]);
        });
      });
    });
    describe("when no line number has been entered", function() {
      return it("closes the view and does not update the cursor position", function() {
        atom.commands.dispatch(editorView, 'go-to-line:toggle');
        expect(goToLine.panel.isVisible()).toBeTruthy();
        atom.commands.dispatch(goToLine.miniEditor.element, 'core:confirm');
        expect(goToLine.panel.isVisible()).toBeFalsy();
        return expect(editor.getCursorBufferPosition()).toEqual([1, 0]);
      });
    });
    describe("when no line number has been entered, but a column number has been entered", function() {
      return it("navigates to the column of the current line", function() {
        atom.commands.dispatch(editorView, 'go-to-line:toggle');
        expect(goToLine.panel.isVisible()).toBeTruthy();
        goToLine.miniEditor.getModel().insertText('4:1');
        atom.commands.dispatch(goToLine.miniEditor.element, 'core:confirm');
        expect(goToLine.panel.isVisible()).toBeFalsy();
        expect(editor.getCursorBufferPosition()).toEqual([3, 0]);
        atom.commands.dispatch(editorView, 'go-to-line:toggle');
        expect(goToLine.panel.isVisible()).toBeTruthy();
        goToLine.miniEditor.getModel().insertText(':19');
        atom.commands.dispatch(goToLine.miniEditor.element, 'core:confirm');
        expect(goToLine.panel.isVisible()).toBeFalsy();
        return expect(editor.getCursorBufferPosition()).toEqual([3, 18]);
      });
    });
    return describe("when core:cancel is triggered", function() {
      return it("closes the view and does not update the cursor position", function() {
        atom.commands.dispatch(editorView, 'go-to-line:toggle');
        expect(goToLine.panel.isVisible()).toBeTruthy();
        atom.commands.dispatch(goToLine.miniEditor.element, 'core:cancel');
        expect(goToLine.panel.isVisible()).toBeFalsy();
        return expect(editor.getCursorBufferPosition()).toEqual([1, 0]);
      });
    });
  });

}).call(this);
