(function() {
  var GrammarListView, SelectListView,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  SelectListView = require('atom-space-pen-views').SelectListView;

  module.exports = GrammarListView = (function(_super) {
    __extends(GrammarListView, _super);

    function GrammarListView() {
      return GrammarListView.__super__.constructor.apply(this, arguments);
    }

    GrammarListView.prototype.initialize = function() {
      GrammarListView.__super__.initialize.apply(this, arguments);
      this.addClass('grammar-selector');
      this.list.addClass('mark-active');
      return this.autoDetect = {
        name: 'Auto Detect'
      };
    };

    GrammarListView.prototype.getFilterKey = function() {
      return 'name';
    };

    GrammarListView.prototype.destroy = function() {
      return this.cancel();
    };

    GrammarListView.prototype.viewForItem = function(grammar) {
      var element, grammarName, _ref;
      element = document.createElement('li');
      if (grammar === this.currentGrammar) {
        element.classList.add('active');
      }
      grammarName = (_ref = grammar.name) != null ? _ref : grammar.scopeName;
      element.textContent = grammarName;
      element.dataset.grammar = grammarName;
      return element;
    };

    GrammarListView.prototype.cancelled = function() {
      var _ref;
      if ((_ref = this.panel) != null) {
        _ref.destroy();
      }
      this.panel = null;
      this.editor = null;
      return this.currentGrammar = null;
    };

    GrammarListView.prototype.confirmed = function(grammar) {
      if (grammar === this.autoDetect) {
        atom.grammars.clearGrammarOverrideForPath(this.editor.getPath());
        this.editor.reloadGrammar();
      } else {
        atom.grammars.setGrammarOverrideForPath(this.editor.getPath(), grammar.scopeName);
        this.editor.setGrammar(grammar);
      }
      return this.cancel();
    };

    GrammarListView.prototype.attach = function() {
      this.storeFocusedElement();
      if (this.panel == null) {
        this.panel = atom.workspace.addModalPanel({
          item: this
        });
      }
      return this.focusFilterEditor();
    };

    GrammarListView.prototype.toggle = function() {
      if (this.panel != null) {
        return this.cancel();
      } else if (this.editor = atom.workspace.getActiveTextEditor()) {
        this.currentGrammar = this.editor.getGrammar();
        if (this.currentGrammar === atom.grammars.nullGrammar) {
          this.currentGrammar = this.autoDetect;
        }
        this.setItems(this.getGrammars());
        return this.attach();
      }
    };

    GrammarListView.prototype.getGrammars = function() {
      var grammars;
      grammars = atom.grammars.getGrammars().filter(function(grammar) {
        return grammar !== atom.grammars.nullGrammar;
      });
      grammars.sort(function(grammarA, grammarB) {
        var _ref, _ref1, _ref2, _ref3;
        if (grammarA.scopeName === 'text.plain') {
          return -1;
        } else if (grammarB.scopeName === 'text.plain') {
          return 1;
        } else {
          return (_ref = (_ref1 = (_ref2 = grammarA.name) != null ? typeof _ref2.localeCompare === "function" ? _ref2.localeCompare(grammarB.name) : void 0 : void 0) != null ? _ref1 : (_ref3 = grammarA.scopeName) != null ? typeof _ref3.localeCompare === "function" ? _ref3.localeCompare(grammarB.name) : void 0 : void 0) != null ? _ref : 1;
        }
      });
      grammars.unshift(this.autoDetect);
      return grammars;
    };

    return GrammarListView;

  })(SelectListView);

}).call(this);
