(function() {
  var Disposable, GrammarStatusView,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  Disposable = require('atom').Disposable;

  GrammarStatusView = (function(_super) {
    __extends(GrammarStatusView, _super);

    function GrammarStatusView() {
      return GrammarStatusView.__super__.constructor.apply(this, arguments);
    }

    GrammarStatusView.prototype.initialize = function(statusBar) {
      this.statusBar = statusBar;
      this.classList.add('grammar-status', 'inline-block');
      this.grammarLink = document.createElement('a');
      this.grammarLink.classList.add('inline-block');
      this.grammarLink.href = '#';
      this.appendChild(this.grammarLink);
      this.handleEvents();
      return this;
    };

    GrammarStatusView.prototype.attach = function() {
      var _ref;
      if ((_ref = this.statusBarTile) != null) {
        _ref.destroy();
      }
      return this.statusBarTile = atom.config.get('grammar-selector.showOnRightSideOfStatusBar') ? this.statusBar.addRightTile({
        item: this,
        priority: 10
      }) : this.statusBar.addLeftTile({
        item: this,
        priority: 10
      });
    };

    GrammarStatusView.prototype.handleEvents = function() {
      var clickHandler;
      this.activeItemSubscription = atom.workspace.onDidChangeActivePaneItem((function(_this) {
        return function() {
          return _this.subscribeToActiveTextEditor();
        };
      })(this));
      this.configSubscription = atom.config.observe('grammar-selector.showOnRightSideOfStatusBar', (function(_this) {
        return function() {
          return _this.attach();
        };
      })(this));
      clickHandler = (function(_this) {
        return function() {
          return atom.commands.dispatch(atom.views.getView(_this.getActiveTextEditor()), 'grammar-selector:show');
        };
      })(this);
      this.addEventListener('click', clickHandler);
      this.clickSubscription = new Disposable((function(_this) {
        return function() {
          return _this.removeEventListener('click', clickHandler);
        };
      })(this));
      return this.subscribeToActiveTextEditor();
    };

    GrammarStatusView.prototype.destroy = function() {
      var _ref, _ref1, _ref2, _ref3;
      if ((_ref = this.activeItemSubscription) != null) {
        _ref.dispose();
      }
      if ((_ref1 = this.grammarSubscription) != null) {
        _ref1.dispose();
      }
      if ((_ref2 = this.clickSubscription) != null) {
        _ref2.dispose();
      }
      if ((_ref3 = this.configSubscription) != null) {
        _ref3.dispose();
      }
      return this.statusBarTile.destroy();
    };

    GrammarStatusView.prototype.getActiveTextEditor = function() {
      return atom.workspace.getActiveTextEditor();
    };

    GrammarStatusView.prototype.subscribeToActiveTextEditor = function() {
      var _ref, _ref1;
      if ((_ref = this.grammarSubscription) != null) {
        _ref.dispose();
      }
      this.grammarSubscription = (_ref1 = this.getActiveTextEditor()) != null ? _ref1.onDidChangeGrammar((function(_this) {
        return function() {
          return _this.updateGrammarText();
        };
      })(this)) : void 0;
      return this.updateGrammarText();
    };

    GrammarStatusView.prototype.updateGrammarText = function() {
      var grammar, grammarName, _ref, _ref1;
      grammar = (_ref = this.getActiveTextEditor()) != null ? typeof _ref.getGrammar === "function" ? _ref.getGrammar() : void 0 : void 0;
      if (grammar != null) {
        if (grammar === atom.grammars.nullGrammar) {
          grammarName = 'Plain Text';
        } else {
          grammarName = (_ref1 = grammar.name) != null ? _ref1 : grammar.scopeName;
        }
        this.grammarLink.textContent = grammarName;
        this.grammarLink.dataset.grammar = grammarName;
        return this.style.display = '';
      } else {
        return this.style.display = 'none';
      }
    };

    return GrammarStatusView;

  })(HTMLDivElement);

  module.exports = document.registerElement('grammar-selector-status', {
    prototype: GrammarStatusView.prototype
  });

}).call(this);
