(function() {
  var commandDisposable, createGrammarListView, grammarListView, grammarStatusView;

  commandDisposable = null;

  grammarListView = null;

  grammarStatusView = null;

  module.exports = {
    config: {
      showOnRightSideOfStatusBar: {
        type: 'boolean',
        "default": true
      }
    },
    activate: function() {
      return commandDisposable = atom.commands.add('atom-text-editor', 'grammar-selector:show', createGrammarListView);
    },
    deactivate: function() {
      if (commandDisposable != null) {
        commandDisposable.dispose();
      }
      commandDisposable = null;
      if (grammarStatusView != null) {
        grammarStatusView.destroy();
      }
      grammarStatusView = null;
      if (grammarListView != null) {
        grammarListView.destroy();
      }
      return grammarListView = null;
    },
    consumeStatusBar: function(statusBar) {
      var GrammarStatusView;
      GrammarStatusView = require('./grammar-status-view');
      grammarStatusView = new GrammarStatusView().initialize(statusBar);
      return grammarStatusView.attach();
    }
  };

  createGrammarListView = function() {
    var GrammarListView;
    if (grammarListView == null) {
      GrammarListView = require('./grammar-list-view');
      grammarListView = new GrammarListView();
    }
    return grammarListView.toggle();
  };

}).call(this);
