(function() {
  var $, invoke, last, path, _ref;

  path = require('path');

  _ref = require('underscore-plus'), last = _ref.last, invoke = _ref.invoke;

  $ = require('atom-space-pen-views').$;

  describe("GrammarSelector", function() {
    var editor, editorView, jsGrammar, textGrammar, workspaceElement, _ref1;
    _ref1 = [], editor = _ref1[0], editorView = _ref1[1], workspaceElement = _ref1[2], textGrammar = _ref1[3], jsGrammar = _ref1[4];
    beforeEach(function() {
      workspaceElement = atom.views.getView(atom.workspace);
      atom.config.set('grammar-selector.showOnRightSideOfStatusBar', false);
      waitsForPromise(function() {
        return atom.packages.activatePackage('status-bar');
      });
      waitsForPromise(function() {
        return atom.packages.activatePackage('grammar-selector');
      });
      waitsForPromise(function() {
        return atom.packages.activatePackage('language-text');
      });
      waitsForPromise(function() {
        return atom.packages.activatePackage('language-javascript');
      });
      waitsForPromise(function() {
        return atom.packages.activatePackage(path.join(__dirname, 'fixtures', 'language-with-no-name'));
      });
      waitsForPromise(function() {
        return atom.workspace.open('sample.js');
      });
      return runs(function() {
        editor = atom.workspace.getActiveTextEditor();
        editorView = atom.views.getView(editor);
        textGrammar = atom.grammars.grammarForScopeName('text.plain');
        expect(textGrammar).toBeTruthy();
        jsGrammar = atom.grammars.grammarForScopeName('source.js');
        expect(jsGrammar).toBeTruthy();
        return expect(editor.getGrammar()).toBe(jsGrammar);
      });
    });
    describe("when grammar-selector:show is triggered", function() {
      return it("displays a list of all the available grammars", function() {
        var grammarView, li, _i, _len, _ref2, _results;
        atom.commands.dispatch(editorView, 'grammar-selector:show');
        grammarView = atom.workspace.getModalPanels()[0].getItem();
        expect(grammarView.list.children('li').length).toBe(atom.grammars.grammars.length);
        expect(grammarView.list.children('li:first').text()).toBe('Auto Detect');
        expect(grammarView.list.children('li:contains(source.a)')).toExist();
        _ref2 = grammarView.list.children('li');
        _results = [];
        for (_i = 0, _len = _ref2.length; _i < _len; _i++) {
          li = _ref2[_i];
          _results.push(expect($(li).text()).not.toBe(atom.grammars.nullGrammar.name));
        }
        return _results;
      });
    });
    describe("when a grammar is selected", function() {
      return it("sets the new grammar on the editor", function() {
        var grammarView;
        atom.commands.dispatch(editorView, 'grammar-selector:show');
        grammarView = atom.workspace.getModalPanels()[0].getItem();
        grammarView.confirmed(textGrammar);
        return expect(editor.getGrammar()).toBe(textGrammar);
      });
    });
    describe("when auto-detect is selected", function() {
      return it("restores the auto-detected grammar on the editor", function() {
        var grammarView;
        atom.commands.dispatch(editorView, 'grammar-selector:show');
        grammarView = atom.workspace.getModalPanels()[0].getItem();
        grammarView.confirmed(textGrammar);
        expect(editor.getGrammar()).toBe(textGrammar);
        atom.commands.dispatch(editorView, 'grammar-selector:show');
        grammarView = atom.workspace.getModalPanels()[0].getItem();
        grammarView.confirmed(grammarView.items[0]);
        return expect(editor.getGrammar()).toBe(jsGrammar);
      });
    });
    describe("when the editor's current grammar is the null grammar", function() {
      return it("displays Auto Detect as the selected grammar", function() {
        var grammarView;
        editor.setGrammar(atom.grammars.nullGrammar);
        atom.commands.dispatch(editorView, 'grammar-selector:show');
        grammarView = atom.workspace.getModalPanels()[0].getItem();
        return expect(grammarView.list.children('li.active').text()).toBe('Auto Detect');
      });
    });
    describe("when editor is untitled", function() {
      return it("sets the new grammar on the editor", function() {
        waitsForPromise(function() {
          return atom.workspace.open();
        });
        return runs(function() {
          var grammarView;
          editor = atom.workspace.getActiveTextEditor();
          editorView = atom.views.getView(editor);
          atom.commands.dispatch(editorView, 'grammar-selector:show');
          expect(editor.getGrammar()).not.toBe(jsGrammar);
          grammarView = atom.workspace.getModalPanels()[0].getItem();
          grammarView.confirmed(jsGrammar);
          return expect(editor.getGrammar()).toBe(jsGrammar);
        });
      });
    });
    return describe("grammar label", function() {
      var grammarStatus, grammarTile, statusBar, _ref2;
      _ref2 = [], grammarStatus = _ref2[0], grammarTile = _ref2[1], statusBar = _ref2[2];
      beforeEach(function() {
        atom.packages.emitter.emit('did-activate-all');
        statusBar = workspaceElement.querySelector("status-bar");
        grammarTile = last(statusBar.getLeftTiles());
        grammarStatus = grammarTile.getItem();
        return jasmine.attachToDOM(grammarStatus);
      });
      it("displays the name of the current grammar", function() {
        return expect(grammarStatus.grammarLink.textContent).toBe('JavaScript');
      });
      it("displays Plain Text when the current grammar is the null grammar", function() {
        editor.setGrammar(atom.grammars.nullGrammar);
        expect(grammarStatus).toBeVisible();
        expect(grammarStatus.grammarLink.textContent).toBe('Plain Text');
        editor.reloadGrammar();
        expect(grammarStatus).toBeVisible();
        return expect(grammarStatus.grammarLink.textContent).toBe('JavaScript');
      });
      it("hides the label when the current grammar is null", function() {
        jasmine.attachToDOM(editorView);
        spyOn(editor, 'getGrammar').andReturn(null);
        editor.setGrammar(atom.grammars.nullGrammar);
        return expect(grammarStatus).toBeHidden();
      });
      describe("when the grammar-selector.showOnRightSideOfStatusBar setting changes", function() {
        return it("moves the item to the preferred side of the status bar", function() {
          expect(invoke(statusBar.getLeftTiles(), 'getItem')).toContain(grammarStatus);
          expect(invoke(statusBar.getRightTiles(), 'getItem')).not.toContain(grammarStatus);
          atom.config.set("grammar-selector.showOnRightSideOfStatusBar", true);
          expect(invoke(statusBar.getLeftTiles(), 'getItem')).not.toContain(grammarStatus);
          expect(invoke(statusBar.getRightTiles(), 'getItem')).toContain(grammarStatus);
          atom.config.set("grammar-selector.showOnRightSideOfStatusBar", false);
          expect(invoke(statusBar.getLeftTiles(), 'getItem')).toContain(grammarStatus);
          return expect(invoke(statusBar.getRightTiles(), 'getItem')).not.toContain(grammarStatus);
        });
      });
      describe("when the editor's grammar changes", function() {
        return it("displays the new grammar of the editor", function() {
          atom.grammars.setGrammarOverrideForPath(editor.getPath(), 'text.plain');
          editor.reloadGrammar();
          expect(grammarStatus.grammarLink.textContent).toBe('Plain Text');
          atom.grammars.setGrammarOverrideForPath(editor.getPath(), 'source.a');
          editor.reloadGrammar();
          return expect(grammarStatus.grammarLink.textContent).toBe('source.a');
        });
      });
      describe("when clicked", function() {
        return it("shows the grammar selector modal", function() {
          var eventHandler;
          eventHandler = jasmine.createSpy('eventHandler');
          atom.commands.add(editorView, 'grammar-selector:show', eventHandler);
          grammarStatus.click();
          return expect(eventHandler).toHaveBeenCalled();
        });
      });
      return describe("when the package is deactivated", function() {
        return it("removes the view", function() {
          spyOn(grammarTile, 'destroy');
          atom.packages.deactivatePackage('grammar-selector');
          return expect(grammarTile.destroy).toHaveBeenCalled();
        });
      });
    });
  });

}).call(this);
