(function() {
  var $, CompositeDisposable, ImageEditor, ImageEditorStatusView, View, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  _ref = require('atom-space-pen-views'), $ = _ref.$, View = _ref.View;

  CompositeDisposable = require('atom').CompositeDisposable;

  ImageEditor = require('./image-editor');

  module.exports = ImageEditorStatusView = (function(_super) {
    __extends(ImageEditorStatusView, _super);

    function ImageEditorStatusView() {
      return ImageEditorStatusView.__super__.constructor.apply(this, arguments);
    }

    ImageEditorStatusView.content = function() {
      return this.div({
        "class": 'status-image inline-block'
      }, (function(_this) {
        return function() {
          return _this.span({
            "class": 'image-size',
            outlet: 'imageSizeStatus'
          });
        };
      })(this));
    };

    ImageEditorStatusView.prototype.initialize = function(statusBar) {
      this.statusBar = statusBar;
      this.disposables = new CompositeDisposable;
      this.attach();
      return this.disposables.add(atom.workspace.onDidChangeActivePaneItem((function(_this) {
        return function() {
          return _this.updateImageSize();
        };
      })(this)));
    };

    ImageEditorStatusView.prototype.attach = function() {
      return this.statusBar.addLeftTile({
        item: this
      });
    };

    ImageEditorStatusView.prototype.attached = function() {
      return this.updateImageSize();
    };

    ImageEditorStatusView.prototype.getImageSize = function(_arg) {
      var originalHeight, originalWidth;
      originalHeight = _arg.originalHeight, originalWidth = _arg.originalWidth;
      return this.imageSizeStatus.text("" + originalWidth + "x" + originalHeight).show();
    };

    ImageEditorStatusView.prototype.updateImageSize = function() {
      var editor, _ref1;
      if ((_ref1 = this.imageLoadDisposable) != null) {
        _ref1.dispose();
      }
      editor = atom.workspace.getActivePaneItem();
      if (editor instanceof ImageEditor) {
        this.editorView = $(atom.views.getView(editor)).view();
        if (this.editorView.loaded) {
          this.getImageSize(this.editorView);
        }
        return this.imageLoadDisposable = this.editorView.onDidLoad((function(_this) {
          return function() {
            if (editor === atom.workspace.getActivePaneItem()) {
              return _this.getImageSize(_this.editorView);
            }
          };
        })(this));
      } else {
        return this.imageSizeStatus.hide();
      }
    };

    return ImageEditorStatusView;

  })(View);

}).call(this);
