(function() {
  var $, CompositeDisposable, Emitter, ImageEditorView, ScrollView, path, _, _ref, _ref1,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  _ = require('underscore-plus');

  path = require('path');

  _ref = require('atom-space-pen-views'), $ = _ref.$, ScrollView = _ref.ScrollView;

  _ref1 = require('atom'), Emitter = _ref1.Emitter, CompositeDisposable = _ref1.CompositeDisposable;

  module.exports = ImageEditorView = (function(_super) {
    __extends(ImageEditorView, _super);

    function ImageEditorView() {
      return ImageEditorView.__super__.constructor.apply(this, arguments);
    }

    ImageEditorView.content = function() {
      return this.div({
        "class": 'image-view',
        tabindex: -1
      }, (function(_this) {
        return function() {
          _this.div({
            "class": 'image-controls',
            outlet: 'imageControls'
          }, function() {
            _this.a({
              outlet: 'whiteTransparentBackgroundButton',
              "class": 'image-controls-color-white',
              value: '#fff'
            }, function() {
              return _this.text('white');
            });
            return _this.a({
              outlet: 'blackTransparentBackgroundButton',
              "class": 'image-controls-color-black',
              value: '#000'
            }, function() {
              return _this.text('black');
            });
          });
          return _this.div({
            "class": 'image-container'
          }, function() {
            return _this.div({
              "class": 'image-container-cell'
            }, function() {
              return _this.img({
                outlet: 'image'
              });
            });
          });
        };
      })(this));
    };

    ImageEditorView.prototype.initialize = function(editor) {
      this.editor = editor;
      ImageEditorView.__super__.initialize.apply(this, arguments);
      return this.emitter = new Emitter;
    };

    ImageEditorView.prototype.attached = function() {
      var _ref2;
      this.disposables = new CompositeDisposable;
      this.loaded = false;
      this.image.hide();
      this.updateImageURI();
      this.disposables.add(this.editor.onDidChange((function(_this) {
        return function() {
          return _this.updateImageURI();
        };
      })(this)));
      this.disposables.add(atom.commands.add(this.element, {
        'image-view:reload': (function(_this) {
          return function() {
            return _this.updateImageURI();
          };
        })(this),
        'image-view:zoom-in': (function(_this) {
          return function() {
            return _this.zoomIn();
          };
        })(this),
        'image-view:zoom-out': (function(_this) {
          return function() {
            return _this.zoomOut();
          };
        })(this),
        'image-view:reset-zoom': (function(_this) {
          return function() {
            return _this.resetZoom();
          };
        })(this)
      }));
      this.image.load((function(_this) {
        return function() {
          _this.originalHeight = _this.image.height();
          _this.originalWidth = _this.image.width();
          _this.loaded = true;
          _this.image.show();
          return _this.emitter.emit('did-load');
        };
      })(this));
      this.disposables.add(atom.tooltips.add(this.whiteTransparentBackgroundButton[0], {
        title: "Use white transparent background"
      }));
      this.disposables.add(atom.tooltips.add(this.blackTransparentBackgroundButton[0], {
        title: "Use black transparent background"
      }));
      if (this.getPane()) {
        this.imageControls.find('a').on('click', (function(_this) {
          return function(e) {
            return _this.changeBackground($(e.target).attr('value'));
          };
        })(this));
        if ((_ref2 = path.extname(this.editor.getPath()).toLowerCase()) === '.jpg' || _ref2 === '.jpeg') {
          return this.imageControls.hide();
        }
      }
    };

    ImageEditorView.prototype.onDidLoad = function(callback) {
      return this.emitter.on('did-load', callback);
    };

    ImageEditorView.prototype.detached = function() {
      return this.disposables.dispose();
    };

    ImageEditorView.prototype.updateImageURI = function() {
      return this.image.attr('src', "" + (this.editor.getURI()) + "?time=" + (Date.now()));
    };

    ImageEditorView.prototype.getPane = function() {
      return this.parents('.pane')[0];
    };

    ImageEditorView.prototype.zoomOut = function() {
      return this.adjustSize(0.9);
    };

    ImageEditorView.prototype.zoomIn = function() {
      return this.adjustSize(1.1);
    };

    ImageEditorView.prototype.resetZoom = function() {
      if (!(this.loaded && this.isVisible())) {
        return;
      }
      this.image.width(this.originalWidth);
      return this.image.height(this.originalHeight);
    };

    ImageEditorView.prototype.adjustSize = function(factor) {
      var newHeight, newWidth;
      if (!(this.loaded && this.isVisible())) {
        return;
      }
      newWidth = this.image.width() * factor;
      newHeight = this.image.height() * factor;
      this.image.width(newWidth);
      return this.image.height(newHeight);
    };

    ImageEditorView.prototype.changeBackground = function(color) {
      if (!(this.loaded && this.isVisible() && color)) {
        return;
      }
      return this.image.css('background-color', color);
    };

    return ImageEditorView;

  })(ScrollView);

}).call(this);
