(function() {
  var CompositeDisposable, File, ImageEditor, fs, path;

  path = require('path');

  fs = require('fs-plus');

  File = require('pathwatcher').File;

  CompositeDisposable = require('atom').CompositeDisposable;

  module.exports = ImageEditor = (function() {
    atom.deserializers.add(ImageEditor);

    ImageEditor.deserialize = function(_arg) {
      var filePath;
      filePath = _arg.filePath;
      if (fs.isFileSync(filePath)) {
        return new ImageEditor(filePath);
      } else {
        return console.warn("Could not deserialize image editor for path '" + filePath + "' because that file no longer exists");
      }
    };

    function ImageEditor(filePath) {
      this.file = new File(filePath);
      this.subscriptions = new CompositeDisposable();
    }

    ImageEditor.prototype.serialize = function() {
      return {
        filePath: this.getPath(),
        deserializer: this.constructor.name
      };
    };

    ImageEditor.prototype.getViewClass = function() {
      return require('./image-editor-view');
    };

    ImageEditor.prototype.onDidChange = function(callback) {
      var changeSubscription;
      changeSubscription = this.file.onDidChange(callback);
      this.subscriptions.add(changeSubscription);
      return changeSubscription;
    };

    ImageEditor.prototype.onDidChangeTitle = function(callback) {
      var renameSubscription;
      renameSubscription = this.file.onDidRename(callback);
      this.subscriptions.add(renameSubscription);
      return renameSubscription;
    };

    ImageEditor.prototype.destroy = function() {
      return this.subscriptions.dispose();
    };

    ImageEditor.prototype.getTitle = function() {
      var filePath;
      if (filePath = this.getPath()) {
        return path.basename(filePath);
      } else {
        return 'untitled';
      }
    };

    ImageEditor.prototype.getURI = function() {
      return this.getPath();
    };

    ImageEditor.prototype.getPath = function() {
      return this.file.getPath();
    };

    ImageEditor.prototype.isEqual = function(other) {
      return other instanceof ImageEditor && this.getURI() === other.getURI();
    };

    return ImageEditor;

  })();

}).call(this);
