(function() {
  var ImageEditor, imageExtensions, openURI, path, _;

  path = require('path');

  _ = require('underscore-plus');

  ImageEditor = require('./image-editor');

  module.exports = {
    activate: function() {
      return this.openerDisposable = atom.workspace.addOpener(openURI);
    },
    deactivate: function() {
      return this.openerDisposable.dispose();
    },
    consumeStatusBar: function(statusBar) {
      var ImageEditorStatusView, view;
      ImageEditorStatusView = require('./image-editor-status-view');
      view = new ImageEditorStatusView(statusBar);
      return view.attach();
    }
  };

  imageExtensions = ['.gif', '.ico', '.jpeg', '.jpg', '.png', '.webp'];

  openURI = function(uriToOpen) {
    var uriExtension;
    uriExtension = path.extname(uriToOpen).toLowerCase();
    if (_.include(imageExtensions, uriExtension)) {
      return new ImageEditor(uriToOpen);
    }
  };

}).call(this);
