(function() {
  var ImageEditor, ImageEditorView, path;

  path = require('path');

  ImageEditor = require('../lib/image-editor');

  ImageEditorView = require('../lib/image-editor-view');

  describe("ImageEditor", function() {
    describe(".deserialize(state)", function() {
      return it("returns undefined if no file exists at the given path", function() {
        var editor, state;
        spyOn(console, 'warn');
        editor = new ImageEditor(path.join(__dirname, 'fixtures', 'binary-file.png'));
        state = editor.serialize();
        expect(ImageEditor.deserialize(state)).toBeDefined();
        state.filePath = 'bogus';
        return expect(ImageEditor.deserialize(state)).toBeUndefined();
      });
    });
    return describe(".activate()", function() {
      return it("registers a project opener that handles image file extension", function() {
        waitsForPromise(function() {
          return atom.packages.activatePackage('image-view');
        });
        runs(function() {
          return atom.workspace.open(path.join(__dirname, 'fixtures', 'binary-file.png'));
        });
        waitsFor(function() {
          return atom.workspace.getActivePaneItem() instanceof ImageEditor;
        });
        runs(function() {
          expect(atom.workspace.getActivePaneItem().getTitle()).toBe('binary-file.png');
          atom.workspace.destroyActivePaneItem();
          atom.packages.deactivatePackage('image-view');
          return atom.workspace.open(path.join(__dirname, 'fixtures', 'binary-file.png'));
        });
        waitsFor(function() {
          return atom.workspace.getActivePaneItem() != null;
        });
        return runs(function() {
          return expect(atom.workspace.getActivePaneItem() instanceof ImageEditor).toBe(false);
        });
      });
    });
  });

}).call(this);
