(function() {
  var $, ImageEditor, ImageEditorView, View, _ref;

  _ref = require('atom-space-pen-views'), View = _ref.View, $ = _ref.$;

  ImageEditorView = require('../lib/image-editor-view');

  ImageEditor = require('../lib/image-editor');

  describe("ImageEditorView", function() {
    var editor, filePath, view, workspaceElement, _ref1;
    _ref1 = [], editor = _ref1[0], view = _ref1[1], filePath = _ref1[2], workspaceElement = _ref1[3];
    beforeEach(function() {
      workspaceElement = atom.views.getView(atom.workspace);
      filePath = atom.project.getDirectories()[0].resolve('binary-file.png');
      editor = new ImageEditor(filePath);
      view = new ImageEditorView(editor);
      view.height(100);
      jasmine.attachToDOM(view.element);
      return waitsFor(function() {
        return view.loaded;
      });
    });
    afterEach(function() {
      editor.destroy();
      return view.remove();
    });
    it("displays the image for a path", function() {
      return expect(view.image.attr('src')).toContain(filePath);
    });
    describe("when the image is changed", function() {
      return it("reloads the image", function() {
        spyOn(view, 'updateImageURI');
        editor.file.emitter.emit('did-change');
        return expect(view.updateImageURI).toHaveBeenCalled();
      });
    });
    describe("when the image is moved", function() {
      return it("updates the title", function() {
        var titleHandler;
        titleHandler = jasmine.createSpy('titleHandler');
        editor.onDidChangeTitle(titleHandler);
        editor.file.emitter.emit('did-rename');
        return expect(titleHandler).toHaveBeenCalled();
      });
    });
    describe("image-view:reload", function() {
      return it("reloads the image", function() {
        spyOn(view, 'updateImageURI');
        atom.commands.dispatch(view.element, 'image-view:reload');
        return expect(view.updateImageURI).toHaveBeenCalled();
      });
    });
    describe("image-view:zoom-in", function() {
      return it("increases the image size by 10%", function() {
        atom.commands.dispatch(view.element, 'image-view:zoom-in');
        expect(view.image.width()).toBe(11);
        return expect(view.image.height()).toBe(11);
      });
    });
    describe("image-view:zoom-out", function() {
      return it("decreases the image size by 10%", function() {
        atom.commands.dispatch(view.element, 'image-view:zoom-out');
        expect(view.image.width()).toBe(9);
        return expect(view.image.height()).toBe(9);
      });
    });
    describe("image-view:reset-zoom", function() {
      return it("restores the image to the original size", function() {
        atom.commands.dispatch(view.element, 'image-view:zoom-in');
        expect(view.image.width()).not.toBe(10);
        expect(view.image.height()).not.toBe(10);
        atom.commands.dispatch(view.element, 'image-view:reset-zoom');
        expect(view.image.width()).toBe(10);
        return expect(view.image.height()).toBe(10);
      });
    });
    return describe("ImageEditorStatusView", function() {
      var imageSizeStatus;
      imageSizeStatus = [][0];
      beforeEach(function() {
        view.detach();
        jasmine.attachToDOM(workspaceElement);
        waitsForPromise(function() {
          return atom.packages.activatePackage('image-view');
        });
        waitsForPromise(function() {
          return atom.workspace.open(filePath);
        });
        runs(function() {
          editor = atom.workspace.getActivePaneItem();
          view = $(atom.views.getView(atom.workspace.getActivePaneItem())).view();
          return view.height(100);
        });
        waitsFor(function() {
          return view.loaded;
        });
        waitsForPromise(function() {
          return atom.packages.activatePackage('status-bar');
        });
        return runs(function() {
          var statusBar;
          statusBar = workspaceElement.querySelector('status-bar');
          imageSizeStatus = $(statusBar.leftPanel.querySelector('.status-image')).view();
          return expect(imageSizeStatus).toExist();
        });
      });
      return it("displays the size of the image", function() {
        return expect(imageSizeStatus.text()).toBe('10x10');
      });
    });
  });

}).call(this);
