(function() {
  var $$, IncompatiblePackageView, View, _, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  _ref = require('atom-space-pen-views'), $$ = _ref.$$, View = _ref.View;

  _ = require('underscore-plus');

  module.exports = IncompatiblePackageView = (function(_super) {
    __extends(IncompatiblePackageView, _super);

    function IncompatiblePackageView() {
      return IncompatiblePackageView.__super__.constructor.apply(this, arguments);
    }

    IncompatiblePackageView.content = function() {
      return this.div({
        "class": 'inset-panel'
      }, (function(_this) {
        return function() {
          _this.div({
            "class": 'panel-heading'
          }, function() {
            _this.span({
              outlet: 'name'
            });
            _this.span({
              outlet: 'version'
            });
            _this.span({
              outlet: 'disabledLabel',
              "class": 'text-info disabled-package'
            }, 'Disabled');
            return _this.div({
              "class": 'btn-toolbar pull-right'
            }, function() {
              return _this.div({
                "class": 'btn-group'
              }, function() {
                _this.button({
                  "class": 'btn',
                  outlet: 'updateButton'
                }, 'Check for Update');
                _this.button({
                  "class": 'btn',
                  outlet: 'issueButton'
                }, 'Report Issue');
                return _this.button({
                  "class": 'btn',
                  outlet: 'disableButton'
                }, 'Disable Package');
              });
            });
          });
          return _this.div({
            "class": 'panel-body padded'
          }, function() {
            _this.p('Listed below are the incompatible native modules that this package depends on.');
            return _this.ul({
              "class": 'list-tree',
              outlet: 'modules'
            });
          });
        };
      })(this));
    };

    IncompatiblePackageView.prototype.initialize = function(pack) {
      var nativeModule, _i, _len, _ref1, _ref2, _results;
      this.pack = pack;
      this.updateButton.on('click', function() {
        atom.commands.dispatch(atom.views.getView(atom.workspace), 'settings-view:install-packages');
        return false;
      });
      this.issueButton.on('click', (function(_this) {
        return function() {
          var repoUrl;
          if (repoUrl = _this.getRepositoryUrl()) {
            require('shell').openExternal("" + repoUrl + "/issues");
          }
          return false;
        };
      })(this));
      this.disabledLabel.hide();
      this.disableButton.on('click', (function(_this) {
        return function() {
          atom.packages.disablePackage(_this.pack.name);
          _this.disabledLabel.show();
          return false;
        };
      })(this));
      this.name.text(_.undasherize(_.uncamelcase(this.pack.name)));
      this.version.text(" " + this.pack.metadata.version);
      _ref2 = (_ref1 = this.pack.incompatibleModules) != null ? _ref1 : [];
      _results = [];
      for (_i = 0, _len = _ref2.length; _i < _len; _i++) {
        nativeModule = _ref2[_i];
        _results.push(this.modules.append($$(function() {
          return this.li({
            "class": 'list-nested-item'
          }, (function(_this) {
            return function() {
              _this.div({
                "class": 'list-item'
              }, function() {
                return _this.span({
                  "class": 'icon icon-file-binary'
                }, "" + nativeModule.name + "@" + nativeModule.version);
              });
              return _this.ul({
                "class": 'list-tree'
              }, function() {
                return _this.li({
                  "class": 'list-nested-item'
                }, function() {
                  return _this.div({
                    "class": 'list-item'
                  }, function() {
                    return _this.span({
                      "class": 'text-warning icon icon-bug'
                    }, "Error message: " + nativeModule.error);
                  });
                });
              });
            };
          })(this));
        })));
      }
      return _results;
    };

    IncompatiblePackageView.prototype.getRepositoryUrl = function() {
      var repoUrl, repository, _ref1, _ref2;
      repository = this.pack.metadata.repository;
      repoUrl = (_ref1 = (_ref2 = repository != null ? repository.url : void 0) != null ? _ref2 : repository) != null ? _ref1 : '';
      return repoUrl.replace(/\.git$/, '').replace(/\/+$/, '');
    };

    return IncompatiblePackageView;

  })(View);

}).call(this);
