(function() {
  var IncompatiblePackagesStatusView, View, _,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  _ = require('underscore-plus');

  View = require('atom-space-pen-views').View;

  module.exports = IncompatiblePackagesStatusView = (function(_super) {
    __extends(IncompatiblePackagesStatusView, _super);

    function IncompatiblePackagesStatusView() {
      return IncompatiblePackagesStatusView.__super__.constructor.apply(this, arguments);
    }

    IncompatiblePackagesStatusView.content = function() {
      return this.div({
        "class": 'incompatible-packages-status inline-block text text-error'
      }, (function(_this) {
        return function() {
          _this.span({
            "class": 'icon icon-bug'
          });
          return _this.span({
            outlet: 'countLabel',
            "class": 'incompatible-packages-status'
          });
        };
      })(this));
    };

    IncompatiblePackagesStatusView.prototype.initialize = function(statusBar, incompatibleCount) {
      this.countLabel.text(incompatibleCount);
      this.tooltipSubscription = atom.tooltips.add(this.element, {
        title: _.pluralize(incompatibleCount, 'incompatible package')
      });
      statusBar.addRightTile({
        item: this
      });
      return this.on('click', (function(_this) {
        return function() {
          atom.commands.dispatch(atom.views.getView(atom.workspace), 'incompatible-packages:view');
          return _this.destroy();
        };
      })(this));
    };

    IncompatiblePackagesStatusView.prototype.destroy = function() {
      this.tooltipSubscription.dispose();
      return this.remove();
    };

    return IncompatiblePackagesStatusView;

  })(View);

}).call(this);
