(function() {
  var $$, Disposable, IncompatiblePackageView, IncompatiblePackagesView, ScrollView, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  _ref = require('atom-space-pen-views'), $$ = _ref.$$, ScrollView = _ref.ScrollView;

  Disposable = require('atom').Disposable;

  IncompatiblePackageView = require('./incompatible-package-view');

  module.exports = IncompatiblePackagesView = (function(_super) {
    __extends(IncompatiblePackagesView, _super);

    function IncompatiblePackagesView() {
      return IncompatiblePackagesView.__super__.constructor.apply(this, arguments);
    }

    IncompatiblePackagesView.content = function() {
      return this.div({
        "class": 'tool-panel panel-bottom padded incompatible-packages native-key-bindings',
        tabindex: -1
      }, (function(_this) {
        return function() {
          return _this.div({
            "class": 'padded'
          }, function() {
            _this.div({
              outlet: 'description'
            });
            return _this.div({
              outlet: 'reloadArea'
            }, function() {
              _this.p("If you think a package is listed here and should no longer be, click\nthe button below to reload Atom and recheck all packages.");
              return _this.button({
                outlet: 'reloadButton',
                "class": 'btn'
              }, 'Reload Atom And Recheck Packages');
            });
          });
        };
      })(this));
    };

    IncompatiblePackagesView.prototype.initialize = function(_arg) {
      this.uri = _arg.uri;
      this.reloadArea.hide();
      if (atom.packages.getActivePackages().length > 0) {
        this.populateViews();
      } else {
        setImmediate((function(_this) {
          return function() {
            return _this.populateViews();
          };
        })(this));
      }
      return this.reloadButton.on('click', function() {
        return atom.commands.dispatch(atom.views.getView(atom.workspace), 'incompatible-packages:reload-atom-and-recheck-packages');
      });
    };

    IncompatiblePackagesView.prototype.onDidChangeTitle = function() {
      return new Disposable();
    };

    IncompatiblePackagesView.prototype.onDidChangeModified = function() {
      return new Disposable();
    };

    IncompatiblePackagesView.prototype.populateViews = function() {
      var incompatiblePackageCount, pack, _i, _len, _ref1;
      incompatiblePackageCount = 0;
      _ref1 = atom.packages.getLoadedPackages();
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        pack = _ref1[_i];
        if (typeof pack.isCompatible === 'function' && !pack.isCompatible()) {
          incompatiblePackageCount++;
          this.append(new IncompatiblePackageView(pack));
        }
      }
      return this.addDescription(incompatiblePackageCount);
    };

    IncompatiblePackagesView.prototype.addDescription = function(incompatiblePackageCount) {
      if (incompatiblePackageCount > 0) {
        this.reloadArea.show();
        return this.description.append($$(function() {
          this.p("The following packages could not be loaded because they contain native\nmodules that aren't compatible with this version of Atom.");
          this.p("Previous Atom versions shipped with Chrome 31 and Node 0.11.10 but\nAtom now ships with Chrome " + process.versions.chrome + " and Node\n" + process.versions.node + ".");
          this.p("The packages listed should now ship versions of these native modules\nthat are compatible with Node " + process.versions.node + ".");
          this.p("Updates for these packages may already be available that resolve\nthis issue.");
          return this.p("If no update is available you may want to notify the package author\nthat their package isn't supported in Atom " + (atom.getVersion()) + "\nbecause of the Chrome " + process.versions.chrome + " and Node\n" + process.versions.node + " upgrade.");
        }));
      } else {
        return this.description.text('All of your packages installed to ~/.atom.packages are compatible with this version of Atom.');
      }
    };

    IncompatiblePackagesView.prototype.serialize = function() {
      return {
        deserializer: this.constructor.name,
        uri: this.getURI()
      };
    };

    IncompatiblePackagesView.prototype.getURI = function() {
      return this.uri;
    };

    IncompatiblePackagesView.prototype.getTitle = function() {
      return 'Incompatible Packages';
    };

    IncompatiblePackagesView.prototype.getIconName = function() {
      return 'package';
    };

    return IncompatiblePackagesView;

  })(ScrollView);

}).call(this);
