(function() {
  var IncompatiblePackagesView, createView, incompatiblePackagesStatusView, openerSubscription, viewUri, workspaceSubscription;

  IncompatiblePackagesView = null;

  viewUri = 'atom://incompatible-packages';

  createView = function(state) {
    if (IncompatiblePackagesView == null) {
      IncompatiblePackagesView = require('./incompatible-packages-view');
    }
    return new IncompatiblePackagesView(state);
  };

  atom.deserializers.add({
    name: 'IncompatiblePackagesView',
    deserialize: function(state) {
      return createView(state);
    }
  });

  incompatiblePackagesStatusView = null;

  openerSubscription = null;

  workspaceSubscription = null;

  module.exports = {
    activate: function() {
      openerSubscription = atom.workspace.addOpener(function(filePath) {
        if (filePath === viewUri) {
          return createView({
            uri: viewUri
          });
        }
      });
      return workspaceSubscription = atom.commands.add('atom-workspace', {
        'incompatible-packages:view': function() {
          return atom.workspace.open(viewUri);
        },
        'incompatible-packages:clear-cache': function() {
          var data, key, _ref, _results;
          _ref = global.localStorage;
          _results = [];
          for (key in _ref) {
            data = _ref[key];
            if (key.indexOf('installed-packages:') === 0) {
              _results.push(global.localStorage.removeItem(key));
            } else {
              _results.push(void 0);
            }
          }
          return _results;
        },
        'incompatible-packages:reload-atom-and-recheck-packages': function() {
          var workspaceView;
          workspaceView = atom.views.getView(atom.workspace);
          atom.commands.dispatch(workspaceView, 'incompatible-packages:clear-cache');
          return atom.commands.dispatch(workspaceView, 'window:reload');
        }
      });
    },
    deactivate: function() {
      if (incompatiblePackagesStatusView != null) {
        incompatiblePackagesStatusView.destroy();
      }
      incompatiblePackagesStatusView = null;
      if (openerSubscription != null) {
        openerSubscription.dispose();
      }
      openerSubscription = null;
      if (workspaceSubscription != null) {
        workspaceSubscription.dispose();
      }
      return workspaceSubscription = null;
    },
    consumeStatusBar: function(statusBar) {
      var IncompatiblePackagesStatusView, incompatibleCount, pack, _i, _len, _ref;
      incompatibleCount = 0;
      _ref = atom.packages.getLoadedPackages();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        pack = _ref[_i];
        if (!pack.isCompatible()) {
          incompatibleCount++;
        }
      }
      if (incompatibleCount > 0) {
        IncompatiblePackagesStatusView = require('./incompatible-packages-status-view');
        return incompatiblePackagesStatusView != null ? incompatiblePackagesStatusView : incompatiblePackagesStatusView = new IncompatiblePackagesStatusView(statusBar, incompatibleCount);
      }
    }
  };

}).call(this);
