(function() {
  var $, path;

  path = require('path');

  $ = require('atom-space-pen-views').$;

  describe("incompatible packages view", function() {
    beforeEach(function() {
      var incompatiblePackage;
      jasmine.attachToDOM(atom.views.getView(atom.workspace));
      incompatiblePackage = atom.packages.loadPackage(path.join(__dirname, 'fixtures', 'incompatible-package'));
      spyOn(incompatiblePackage, 'isCompatible').andReturn(false);
      waitsForPromise(function() {
        return atom.packages.activatePackage('status-bar');
      });
      return waitsForPromise(function() {
        return atom.packages.activatePackage('incompatible-packages');
      });
    });
    it("opens a pane item when incompatible-packages:view is dispatched", function() {
      expect(atom.workspace.getActivePaneItem()).toBeFalsy();
      atom.commands.dispatch(atom.views.getView(atom.workspace), 'incompatible-packages:view');
      return waitsFor(function() {
        return atom.workspace.getActivePaneItem();
      });
    });
    return describe("when the status bar entry is clicked", function() {
      return it("opens the pane item", function() {
        expect(atom.workspace.getActivePaneItem()).toBeFalsy();
        $('.incompatible-packages-status').click();
        waitsFor(function() {
          return atom.workspace.getActivePaneItem();
        });
        return runs(function() {
          return expect($('.incompatible-packages-status').length).toBe(0);
        });
      });
    });
  });

}).call(this);
