(function() {
  var $$, CompositeDisposable, Disposable, KeyBindingResolverView, View, _ref, _ref1,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  _ref = require('atom'), Disposable = _ref.Disposable, CompositeDisposable = _ref.CompositeDisposable;

  _ref1 = require('atom-space-pen-views'), $$ = _ref1.$$, View = _ref1.View;

  module.exports = KeyBindingResolverView = (function(_super) {
    __extends(KeyBindingResolverView, _super);

    function KeyBindingResolverView() {
      return KeyBindingResolverView.__super__.constructor.apply(this, arguments);
    }

    KeyBindingResolverView.content = function() {
      return this.div({
        "class": 'key-binding-resolver'
      }, (function(_this) {
        return function() {
          _this.div({
            "class": 'panel-heading padded'
          }, function() {
            _this.span('Key Binding Resolver: ');
            return _this.span({
              outlet: 'keystroke'
            }, 'Press any key');
          });
          return _this.div({
            outlet: 'commands',
            "class": 'panel-body padded'
          });
        };
      })(this));
    };

    KeyBindingResolverView.prototype.initialize = function() {
      return this.on('click', '.source', function(event) {
        return atom.workspace.open(event.target.innerText);
      });
    };

    KeyBindingResolverView.prototype.serialize = function() {
      var _ref2;
      return {
        attached: (_ref2 = this.panel) != null ? _ref2.isVisible() : void 0
      };
    };

    KeyBindingResolverView.prototype.destroy = function() {
      return this.detach();
    };

    KeyBindingResolverView.prototype.toggle = function() {
      var _ref2;
      if ((_ref2 = this.panel) != null ? _ref2.isVisible() : void 0) {
        return this.detach();
      } else {
        return this.attach();
      }
    };

    KeyBindingResolverView.prototype.attach = function() {
      this.disposables = new CompositeDisposable;
      this.panel = atom.workspace.addBottomPanel({
        item: this
      });
      this.disposables.add(new Disposable((function(_this) {
        return function() {
          _this.panel.destroy();
          return _this.panel = null;
        };
      })(this)));
      this.disposables.add(atom.keymaps.onDidMatchBinding((function(_this) {
        return function(_arg) {
          var binding, keyboardEventTarget, keystrokes;
          keystrokes = _arg.keystrokes, binding = _arg.binding, keyboardEventTarget = _arg.keyboardEventTarget;
          return _this.update(keystrokes, binding, keyboardEventTarget);
        };
      })(this)));
      this.disposables.add(atom.keymaps.onDidPartiallyMatchBindings((function(_this) {
        return function(_arg) {
          var keyboardEventTarget, keystrokes, partiallyMatchedBindings;
          keystrokes = _arg.keystrokes, partiallyMatchedBindings = _arg.partiallyMatchedBindings, keyboardEventTarget = _arg.keyboardEventTarget;
          return _this.updatePartial(keystrokes, partiallyMatchedBindings);
        };
      })(this)));
      return this.disposables.add(atom.keymaps.onDidFailToMatchBinding((function(_this) {
        return function(_arg) {
          var keyboardEventTarget, keystrokes;
          keystrokes = _arg.keystrokes, keyboardEventTarget = _arg.keyboardEventTarget;
          return _this.update(keystrokes, null, keyboardEventTarget);
        };
      })(this)));
    };

    KeyBindingResolverView.prototype.detach = function() {
      var _ref2;
      return (_ref2 = this.disposables) != null ? _ref2.dispose() : void 0;
    };

    KeyBindingResolverView.prototype.update = function(keystrokes, keyBinding, keyboardEventTarget) {
      var unmatchedKeyBindings, unusedKeyBindings;
      this.keystroke.html($$(function() {
        return this.span({
          "class": 'keystroke'
        }, keystrokes);
      }));
      unusedKeyBindings = atom.keymaps.findKeyBindings({
        keystrokes: keystrokes,
        target: keyboardEventTarget
      }).filter(function(binding) {
        return binding !== keyBinding;
      });
      unmatchedKeyBindings = atom.keymaps.findKeyBindings({
        keystrokes: keystrokes
      }).filter(function(binding) {
        return binding !== keyBinding && __indexOf.call(unusedKeyBindings, binding) < 0;
      });
      return this.commands.html($$(function() {
        return this.table({
          "class": 'table-condensed'
        }, (function(_this) {
          return function() {
            var binding, _i, _j, _len, _len1, _results;
            if (keyBinding) {
              _this.tr({
                "class": 'used'
              }, function() {
                _this.td({
                  "class": 'command'
                }, keyBinding.command);
                _this.td({
                  "class": 'selector'
                }, keyBinding.selector);
                return _this.td({
                  "class": 'source'
                }, keyBinding.source);
              });
            }
            for (_i = 0, _len = unusedKeyBindings.length; _i < _len; _i++) {
              binding = unusedKeyBindings[_i];
              _this.tr({
                "class": 'unused'
              }, function() {
                _this.td({
                  "class": 'command'
                }, binding.command);
                _this.td({
                  "class": 'selector'
                }, binding.selector);
                return _this.td({
                  "class": 'source'
                }, binding.source);
              });
            }
            _results = [];
            for (_j = 0, _len1 = unmatchedKeyBindings.length; _j < _len1; _j++) {
              binding = unmatchedKeyBindings[_j];
              _results.push(_this.tr({
                "class": 'unmatched'
              }, function() {
                _this.td({
                  "class": 'command'
                }, binding.command);
                _this.td({
                  "class": 'selector'
                }, binding.selector);
                return _this.td({
                  "class": 'source'
                }, binding.source);
              }));
            }
            return _results;
          };
        })(this));
      }));
    };

    KeyBindingResolverView.prototype.updatePartial = function(keystrokes, keyBindings) {
      this.keystroke.html($$(function() {
        return this.span({
          "class": 'keystroke'
        }, "" + keystrokes + " (partial)");
      }));
      return this.commands.html($$(function() {
        return this.table({
          "class": 'table-condensed'
        }, (function(_this) {
          return function() {
            var binding, _i, _len, _results;
            _results = [];
            for (_i = 0, _len = keyBindings.length; _i < _len; _i++) {
              binding = keyBindings[_i];
              _results.push(_this.tr({
                "class": 'unused'
              }, function() {
                _this.td({
                  "class": 'command'
                }, binding.command);
                _this.td({
                  "class": 'keystrokes'
                }, binding.keystrokes);
                _this.td({
                  "class": 'selector'
                }, binding.selector);
                return _this.td({
                  "class": 'source'
                }, binding.source);
              }));
            }
            return _results;
          };
        })(this));
      }));
    };

    return KeyBindingResolverView;

  })(View);

}).call(this);
