(function() {
  module.exports = {
    keybindingResolverView: null,
    activate: function(_arg) {
      var attached;
      attached = (_arg != null ? _arg : {}).attached;
      if (attached) {
        this.createView().toggle();
      }
      return atom.commands.add('atom-workspace', {
        'key-binding-resolver:toggle': (function(_this) {
          return function() {
            return _this.createView().toggle();
          };
        })(this),
        'core:cancel': (function(_this) {
          return function() {
            return _this.createView().detach();
          };
        })(this),
        'core:close': (function(_this) {
          return function() {
            return _this.createView().detach();
          };
        })(this)
      });
    },
    createView: function() {
      var KeyBindingResolverView;
      if (this.keybindingResolverView == null) {
        KeyBindingResolverView = require('./keybinding-resolver-view');
        this.keybindingResolverView = new KeyBindingResolverView();
      }
      return this.keybindingResolverView;
    },
    deactivate: function() {
      var _ref;
      return (_ref = this.keybindingResolverView) != null ? _ref.destroy() : void 0;
    },
    serialize: function() {
      var _ref;
      return (_ref = this.keybindingResolverView) != null ? _ref.serialize() : void 0;
    }
  };

}).call(this);
