(function() {
  var $, KeyBindingResolverView;

  KeyBindingResolverView = require('../lib/keybinding-resolver-view');

  $ = require('atom-space-pen-views').$;

  describe("KeyBindingResolverView", function() {
    var workspaceElement;
    workspaceElement = null;
    beforeEach(function() {
      workspaceElement = atom.views.getView(atom.workspace);
      return waitsForPromise(function() {
        return atom.packages.activatePackage('keybinding-resolver');
      });
    });
    describe("when the key-binding-resolver:toggle event is triggered", function() {
      return it("attaches and then detaches the view", function() {
        expect(workspaceElement.querySelector('.key-binding-resolver')).not.toExist();
        atom.commands.dispatch(workspaceElement, 'key-binding-resolver:toggle');
        expect(workspaceElement.querySelector('.key-binding-resolver')).toExist();
        atom.commands.dispatch(workspaceElement, 'key-binding-resolver:toggle');
        expect(workspaceElement.querySelector('.key-binding-resolver')).not.toExist();
        atom.commands.dispatch(workspaceElement, 'key-binding-resolver:toggle');
        return expect(workspaceElement.querySelector('.key-binding-resolver')).toExist();
      });
    });
    return describe("when a keydown event occurs", function() {
      return it("displays all commands for the event", function() {
        atom.keymaps.add('name', {
          '.workspace': {
            'x': 'match-1'
          }
        });
        atom.keymaps.add('name', {
          '.workspace': {
            'x': 'match-2'
          }
        });
        atom.keymaps.add('name', {
          '.never-again': {
            'x': 'unmatch-2'
          }
        });
        atom.commands.dispatch(workspaceElement, 'key-binding-resolver:toggle');
        document.dispatchEvent(atom.keymaps.constructor.buildKeydownEvent('x', {
          target: workspaceElement
        }));
        expect(workspaceElement.querySelectorAll('.key-binding-resolver .used')).toHaveLength(1);
        expect(workspaceElement.querySelectorAll('.key-binding-resolver .unused')).toHaveLength(1);
        return expect(workspaceElement.querySelectorAll('.key-binding-resolver .unmatched')).toHaveLength(1);
      });
    });
  });

}).call(this);
