(function() {
  var TextEditor;

  TextEditor = require('atom').TextEditor;

  describe('Language-C', function() {
    var grammar;
    grammar = null;
    beforeEach(function() {
      return waitsForPromise(function() {
        return atom.packages.activatePackage('language-c');
      });
    });
    describe("C", function() {
      beforeEach(function() {
        return grammar = atom.grammars.grammarForScopeName('source.c');
      });
      it('parses the grammar', function() {
        expect(grammar).toBeTruthy();
        return expect(grammar.scopeName).toBe('source.c');
      });
      it('tokenizes functions', function() {
        var lines;
        lines = grammar.tokenizeLines('int something() {\n  return 0;\n}');
        expect(lines[0][0]).toEqual({
          value: 'int',
          scopes: ["source.c", "storage.type.c"]
        });
        return expect(lines[0][2]).toEqual({
          value: 'something',
          scopes: ["source.c", "meta.function.c", "entity.name.function.c"]
        });
      });
      return describe("indentation", function() {
        var editor, expectPreservedIndentation;
        editor = null;
        beforeEach(function() {
          editor = new TextEditor({});
          return editor.setGrammar(grammar);
        });
        expectPreservedIndentation = function(text) {
          var actualLine, actualLines, expectedLines, i, _i, _len, _results;
          editor.setText(text);
          editor.autoIndentBufferRows(0, editor.getLineCount() - 1);
          expectedLines = text.split("\n");
          actualLines = editor.getText().split("\n");
          _results = [];
          for (i = _i = 0, _len = actualLines.length; _i < _len; i = ++_i) {
            actualLine = actualLines[i];
            _results.push(expect([actualLine, editor.indentLevelForLine(actualLine)]).toEqual([expectedLines[i], editor.indentLevelForLine(expectedLines[i])]));
          }
          return _results;
        };
        it("indents allman-style curly braces", function() {
          return expectPreservedIndentation("if (a)\n{\n  for (;;)\n  {\n    do\n    {\n      while (b)\n      {\n        c();\n      }\n    }\n    while (d)\n  }\n}");
        });
        it("indents non-allman-style curly braces", function() {
          return expectPreservedIndentation("if (a) {\n  for (;;) {\n    do {\n      while (b) {\n        c();\n      }\n    } while (d)\n  }\n}");
        });
        it("indents function arguments", function() {
          return expectPreservedIndentation("a(\n  b,\n  c(\n    d\n  )\n);");
        });
        return it("indents array and struct literals", function() {
          return expectPreservedIndentation("some_t a[3] = {\n  { .b = c },\n  { .b = c, .d = {1, 2} },\n};");
        });
      });
    });
    return describe("C++", function() {
      beforeEach(function() {
        return grammar = atom.grammars.grammarForScopeName('source.cpp');
      });
      it('parses the grammar', function() {
        expect(grammar).toBeTruthy();
        return expect(grammar.scopeName).toBe('source.cpp');
      });
      return it('tokenizes classes', function() {
        var lines;
        lines = grammar.tokenizeLines('class Thing {\n  int x;\n}');
        expect(lines[0][0]).toEqual({
          value: 'class',
          scopes: ["source.cpp", "meta.class-struct-block.cpp", "storage.type.cpp"]
        });
        return expect(lines[0][2]).toEqual({
          value: 'Thing',
          scopes: ["source.cpp", "meta.class-struct-block.cpp", "entity.name.type.cpp"]
        });
      });
    });
  });

}).call(this);
