(function() {
  describe('HTML grammar', function() {
    var grammar;
    grammar = null;
    beforeEach(function() {
      waitsForPromise(function() {
        return atom.packages.activatePackage('language-html');
      });
      waitsForPromise(function() {
        return atom.packages.activatePackage('language-coffee-script');
      });
      return runs(function() {
        return grammar = atom.grammars.grammarForScopeName('text.html.basic');
      });
    });
    it('parses the grammar', function() {
      expect(grammar).toBeTruthy();
      return expect(grammar.scopeName).toBe('text.html.basic');
    });
    describe('template script tags', function() {
      return it('tokenizes the content inside the tag as HTML', function() {
        var lines;
        lines = grammar.tokenizeLines('<script id=\'id\' type=\'text/template\'>\n  <div>test</div>\n</script>');
        expect(lines[1][0]).toEqual({
          value: '  ',
          scopes: ['text.html.basic', 'text.embedded.html']
        });
        return expect(lines[1][1]).toEqual({
          value: '<',
          scopes: ['text.html.basic', 'text.embedded.html', 'meta.tag.block.any.html', 'punctuation.definition.tag.begin.html']
        });
      });
    });
    return describe('CoffeeScript script tags', function() {
      return it('tokenizes the content inside the tag as CoffeeScript', function() {
        var lines;
        lines = grammar.tokenizeLines('<script id=\'id\' type=\'text/coffeescript\'>\n  -> console.log \'hi\'\n</script>');
        expect(lines[1][0]).toEqual({
          value: '  ',
          scopes: ['text.html.basic', 'source.coffee.embedded.html']
        });
        return expect(lines[1][1]).toEqual({
          value: '->',
          scopes: ['text.html.basic', 'source.coffee.embedded.html', 'storage.type.function.coffee']
        });
      });
    });
  });

}).call(this);
