(function() {
  describe('Hyperlink grammar', function() {
    var grammar;
    grammar = null;
    beforeEach(function() {
      waitsForPromise(function() {
        return atom.packages.activatePackage('language-hyperlink');
      });
      return runs(function() {
        return grammar = atom.grammars.grammarForScopeName('text.hyperlink');
      });
    });
    it('parses the grammar', function() {
      expect(grammar).toBeTruthy();
      return expect(grammar.scopeName).toBe('text.hyperlink');
    });
    return it('parses http: and https: links', function() {
      var plainGrammar, tokens;
      plainGrammar = atom.grammars.selectGrammar();
      tokens = plainGrammar.tokenizeLine('http://github.com').tokens;
      expect(tokens[0]).toEqual({
        value: 'http://github.com',
        scopes: ['text.plain.null-grammar', 'markup.underline.link.http.hyperlink']
      });
      tokens = plainGrammar.tokenizeLine('https://github.com').tokens;
      return expect(tokens[0]).toEqual({
        value: 'https://github.com',
        scopes: ['text.plain.null-grammar', 'markup.underline.link.https.hyperlink']
      });
    });
  });

}).call(this);
