(function() {
  describe("less grammar", function() {
    var grammar;
    grammar = null;
    beforeEach(function() {
      waitsForPromise(function() {
        return atom.packages.activatePackage("language-less");
      });
      return runs(function() {
        return grammar = atom.grammars.grammarForScopeName("source.css.less");
      });
    });
    it("parses the grammar", function() {
      expect(grammar).toBeDefined();
      return expect(grammar.scopeName).toBe("source.css.less");
    });
    it("parses constant.numeric.css", function() {
      var tokens;
      tokens = grammar.tokenizeLine(" 10").tokens;
      expect(tokens).toHaveLength(2);
      expect(tokens[0]).toEqual({
        value: " ",
        scopes: ['source.css.less']
      });
      expect(tokens[1]).toEqual({
        value: "10",
        scopes: ['source.css.less', 'constant.numeric.css']
      });
      tokens = grammar.tokenizeLine("-.1").tokens;
      expect(tokens).toHaveLength(1);
      expect(tokens[0]).toEqual({
        value: "-.1",
        scopes: ['source.css.less', 'constant.numeric.css']
      });
      tokens = grammar.tokenizeLine(".4").tokens;
      expect(tokens).toHaveLength(1);
      return expect(tokens[0]).toEqual({
        value: ".4",
        scopes: ['source.css.less', 'constant.numeric.css']
      });
    });
    it("parses property names", function() {
      var tokens;
      tokens = grammar.tokenizeLine("display: none;").tokens;
      expect(tokens[0]).toEqual({
        value: "display",
        scopes: ['source.css.less', 'support.type.property-name.css']
      });
      tokens = grammar.tokenizeLine("displaya: none;").tokens;
      return expect(tokens[0]).toEqual({
        value: "displaya",
        scopes: ['source.css.less']
      });
    });
    it("parses property names distinctly from property values with the same text", function() {
      var tokens;
      tokens = grammar.tokenizeLine("left: left;").tokens;
      expect(tokens).toHaveLength(5);
      expect(tokens[0]).toEqual({
        value: "left",
        scopes: ['source.css.less', 'support.type.property-name.css']
      });
      expect(tokens[1]).toEqual({
        value: ":",
        scopes: ['source.css.less', 'meta.property-value.css', 'punctuation.separator.key-value.css']
      });
      expect(tokens[2]).toEqual({
        value: " ",
        scopes: ['source.css.less', 'meta.property-value.css']
      });
      expect(tokens[3]).toEqual({
        value: "left",
        scopes: ['source.css.less', 'meta.property-value.css', 'support.constant.property-value.css']
      });
      expect(tokens[4]).toEqual({
        value: ";",
        scopes: ['source.css.less', 'meta.property-value.css', 'punctuation.terminator.rule.css']
      });
      tokens = grammar.tokenizeLine("left:left;").tokens;
      expect(tokens).toHaveLength(4);
      expect(tokens[0]).toEqual({
        value: "left",
        scopes: ['source.css.less', 'support.type.property-name.css']
      });
      expect(tokens[1]).toEqual({
        value: ":",
        scopes: ['source.css.less', 'meta.property-value.css', 'punctuation.separator.key-value.css']
      });
      expect(tokens[2]).toEqual({
        value: "left",
        scopes: ['source.css.less', 'meta.property-value.css', 'support.constant.property-value.css']
      });
      return expect(tokens[3]).toEqual({
        value: ";",
        scopes: ['source.css.less', 'meta.property-value.css', 'punctuation.terminator.rule.css']
      });
    });
    it("parses property names distinctly from element selectors with the same prefix", function() {
      var tokens;
      tokens = grammar.tokenizeLine("table-layout: fixed;").tokens;
      expect(tokens).toHaveLength(5);
      expect(tokens[0]).toEqual({
        value: "table-layout",
        scopes: ['source.css.less', 'support.type.property-name.css']
      });
      expect(tokens[1]).toEqual({
        value: ":",
        scopes: ['source.css.less', 'meta.property-value.css', 'punctuation.separator.key-value.css']
      });
      expect(tokens[2]).toEqual({
        value: " ",
        scopes: ['source.css.less', 'meta.property-value.css']
      });
      expect(tokens[3]).toEqual({
        value: "fixed",
        scopes: ['source.css.less', 'meta.property-value.css', 'support.constant.property-value.css']
      });
      return expect(tokens[4]).toEqual({
        value: ";",
        scopes: ['source.css.less', 'meta.property-value.css', 'punctuation.terminator.rule.css']
      });
    });
    it("parses id selectors", function() {
      var tokens;
      tokens = grammar.tokenizeLine("#abc {}").tokens;
      expect(tokens).toHaveLength(5);
      expect(tokens[0]).toEqual({
        value: "#",
        scopes: ['source.css.less', 'meta.selector.css', 'entity.other.attribute-name.id', 'punctuation.definition.entity.css']
      });
      expect(tokens[1]).toEqual({
        value: "abc",
        scopes: ['source.css.less', 'meta.selector.css', 'entity.other.attribute-name.id']
      });
      tokens = grammar.tokenizeLine("#abc-123 {}").tokens;
      expect(tokens).toHaveLength(5);
      expect(tokens[0]).toEqual({
        value: "#",
        scopes: ['source.css.less', 'meta.selector.css', 'entity.other.attribute-name.id', 'punctuation.definition.entity.css']
      });
      return expect(tokens[1]).toEqual({
        value: "abc-123",
        scopes: ['source.css.less', 'meta.selector.css', 'entity.other.attribute-name.id']
      });
    });
    it("parses property lists", function() {
      var tokens;
      tokens = grammar.tokenizeLine(".foo { border: none; }").tokens;
      expect(tokens).toHaveLength(12);
      expect(tokens[0]).toEqual({
        value: ".",
        scopes: ['source.css.less', 'entity.other.attribute-name.class.css', 'punctuation.definition.entity.css']
      });
      expect(tokens[1]).toEqual({
        value: "foo",
        scopes: ['source.css.less', 'entity.other.attribute-name.class.css']
      });
      expect(tokens[2]).toEqual({
        value: " ",
        scopes: ['source.css.less']
      });
      expect(tokens[3]).toEqual({
        value: "{",
        scopes: ['source.css.less', 'meta.property-list.css', 'punctuation.section.property-list.begin.css']
      });
      expect(tokens[4]).toEqual({
        value: " ",
        scopes: ['source.css.less', 'meta.property-list.css']
      });
      expect(tokens[5]).toEqual({
        value: "border",
        scopes: ['source.css.less', 'meta.property-list.css', 'support.type.property-name.css']
      });
      expect(tokens[6]).toEqual({
        value: ":",
        scopes: ['source.css.less', 'meta.property-list.css', 'meta.property-value.css', 'punctuation.separator.key-value.css']
      });
      expect(tokens[7]).toEqual({
        value: " ",
        scopes: ['source.css.less', 'meta.property-list.css', 'meta.property-value.css']
      });
      expect(tokens[8]).toEqual({
        value: "none",
        scopes: ['source.css.less', 'meta.property-list.css', 'meta.property-value.css', 'support.constant.property-value.css']
      });
      expect(tokens[9]).toEqual({
        value: ";",
        scopes: ['source.css.less', 'meta.property-list.css', 'meta.property-value.css', 'punctuation.terminator.rule.css']
      });
      expect(tokens[10]).toEqual({
        value: " ",
        scopes: ['source.css.less', 'meta.property-list.css']
      });
      return expect(tokens[11]).toEqual({
        value: "}",
        scopes: ['source.css.less', 'meta.property-list.css', 'punctuation.section.property-list.end.css']
      });
    });
    return it("parses variables", function() {
      var tokens;
      tokens = grammar.tokenizeLine(".foo { border: @bar; }").tokens;
      expect(tokens).toHaveLength(12);
      expect(tokens[0]).toEqual({
        value: ".",
        scopes: ['source.css.less', 'entity.other.attribute-name.class.css', 'punctuation.definition.entity.css']
      });
      expect(tokens[1]).toEqual({
        value: "foo",
        scopes: ['source.css.less', 'entity.other.attribute-name.class.css']
      });
      expect(tokens[2]).toEqual({
        value: " ",
        scopes: ['source.css.less']
      });
      expect(tokens[3]).toEqual({
        value: "{",
        scopes: ['source.css.less', 'meta.property-list.css', 'punctuation.section.property-list.begin.css']
      });
      expect(tokens[4]).toEqual({
        value: " ",
        scopes: ['source.css.less', 'meta.property-list.css']
      });
      expect(tokens[5]).toEqual({
        value: "border",
        scopes: ['source.css.less', 'meta.property-list.css', 'support.type.property-name.css']
      });
      expect(tokens[6]).toEqual({
        value: ":",
        scopes: ['source.css.less', 'meta.property-list.css', 'meta.property-value.css', 'punctuation.separator.key-value.css']
      });
      expect(tokens[7]).toEqual({
        value: " ",
        scopes: ['source.css.less', 'meta.property-list.css', 'meta.property-value.css']
      });
      expect(tokens[8]).toEqual({
        value: "@bar",
        scopes: ['source.css.less', 'meta.property-list.css', 'meta.property-value.css', 'variable.other.less']
      });
      expect(tokens[9]).toEqual({
        value: ";",
        scopes: ['source.css.less', 'meta.property-list.css', 'meta.property-value.css', 'punctuation.terminator.rule.css']
      });
      expect(tokens[10]).toEqual({
        value: " ",
        scopes: ['source.css.less', 'meta.property-list.css']
      });
      return expect(tokens[11]).toEqual({
        value: "}",
        scopes: ['source.css.less', 'meta.property-list.css', 'punctuation.section.property-list.end.css']
      });
    });
  });

}).call(this);
