(function() {
  describe('Mustache grammar', function() {
    var grammar;
    grammar = null;
    beforeEach(function() {
      waitsForPromise(function() {
        return atom.packages.activatePackage('language-mustache');
      });
      return runs(function() {
        return grammar = atom.grammars.grammarForScopeName('text.html.mustache');
      });
    });
    it('parses the grammar', function() {
      expect(grammar).toBeTruthy();
      return expect(grammar.scopeName).toBe('text.html.mustache');
    });
    it('parses expressions', function() {
      var tokens;
      tokens = grammar.tokenizeLine("{{name}}").tokens;
      expect(tokens[0]).toEqual({
        value: '{{',
        scopes: ['text.html.mustache', 'meta.tag.template.mustache', 'entity.name.tag.mustache']
      });
      expect(tokens[1]).toEqual({
        value: 'name',
        scopes: ['text.html.mustache', 'meta.tag.template.mustache']
      });
      return expect(tokens[2]).toEqual({
        value: '}}',
        scopes: ['text.html.mustache', 'meta.tag.template.mustache', 'entity.name.tag.mustache']
      });
    });
    it('parses comments', function() {
      var tokens;
      tokens = grammar.tokenizeLine("{{!comment}}").tokens;
      expect(tokens[0]).toEqual({
        value: '{{!',
        scopes: ['text.html.mustache', 'comment.block.mustache']
      });
      expect(tokens[1]).toEqual({
        value: 'comment',
        scopes: ['text.html.mustache', 'comment.block.mustache']
      });
      return expect(tokens[2]).toEqual({
        value: '}}',
        scopes: ['text.html.mustache', 'comment.block.mustache']
      });
    });
    it('parses block expression', function() {
      var tokens;
      tokens = grammar.tokenizeLine("{{#each people}}").tokens;
      expect(tokens[0]).toEqual({
        value: '{{',
        scopes: ['text.html.mustache', 'meta.tag.template.mustache', 'entity.name.tag.mustache']
      });
      expect(tokens[1]).toEqual({
        value: '#',
        scopes: ['text.html.mustache', 'meta.tag.template.mustache', 'entity.name.tag.mustache', 'punctuation.definition.block.begin.mustache']
      });
      expect(tokens[2]).toEqual({
        value: 'each',
        scopes: ['text.html.mustache', 'meta.tag.template.mustache', 'entity.name.tag.mustache', 'entity.name.function.mustache']
      });
      expect(tokens[3]).toEqual({
        value: ' people',
        scopes: ['text.html.mustache', 'meta.tag.template.mustache']
      });
      expect(tokens[4]).toEqual({
        value: '}}',
        scopes: ['text.html.mustache', 'meta.tag.template.mustache', 'entity.name.tag.mustache']
      });
      tokens = grammar.tokenizeLine("{{^repo}}").tokens;
      expect(tokens[0]).toEqual({
        value: '{{',
        scopes: ['text.html.mustache', 'meta.tag.template.mustache', 'entity.name.tag.mustache']
      });
      expect(tokens[1]).toEqual({
        value: '^',
        scopes: ['text.html.mustache', 'meta.tag.template.mustache', 'entity.name.tag.mustache', 'punctuation.definition.block.begin.mustache']
      });
      expect(tokens[2]).toEqual({
        value: 'repo',
        scopes: ['text.html.mustache', 'meta.tag.template.mustache', 'entity.name.tag.mustache', 'entity.name.function.mustache']
      });
      expect(tokens[3]).toEqual({
        value: '}}',
        scopes: ['text.html.mustache', 'meta.tag.template.mustache', 'entity.name.tag.mustache']
      });
      tokens = grammar.tokenizeLine("{{/if}}").tokens;
      expect(tokens[0]).toEqual({
        value: '{{',
        scopes: ['text.html.mustache', 'meta.tag.template.mustache', 'entity.name.tag.mustache']
      });
      expect(tokens[1]).toEqual({
        value: '/',
        scopes: ['text.html.mustache', 'meta.tag.template.mustache', 'entity.name.tag.mustache', 'punctuation.definition.block.end.mustache']
      });
      expect(tokens[2]).toEqual({
        value: 'if',
        scopes: ['text.html.mustache', 'meta.tag.template.mustache', 'entity.name.tag.mustache', 'entity.name.function.mustache']
      });
      return expect(tokens[3]).toEqual({
        value: '}}',
        scopes: ['text.html.mustache', 'meta.tag.template.mustache', 'entity.name.tag.mustache']
      });
    });
    return it('parses unescaped expressions', function() {
      var tokens;
      tokens = grammar.tokenizeLine("{{{do not escape me}}}").tokens;
      expect(tokens[0]).toEqual({
        value: '{{{',
        scopes: ['text.html.mustache', 'meta.tag.template.raw.mustache', 'entity.name.tag.mustache']
      });
      expect(tokens[1]).toEqual({
        value: 'do not escape me',
        scopes: ['text.html.mustache', 'meta.tag.template.raw.mustache']
      });
      return expect(tokens[2]).toEqual({
        value: '}}}',
        scopes: ['text.html.mustache', 'meta.tag.template.raw.mustache', 'entity.name.tag.mustache']
      });
    });
  });

}).call(this);
