(function() {
  describe('Language-Objective-C', function() {
    var grammar;
    grammar = null;
    beforeEach(function() {
      waitsForPromise(function() {
        return atom.packages.activatePackage('language-objective-c');
      });
      return waitsForPromise(function() {
        return atom.packages.activatePackage('language-c');
      });
    });
    describe("Objective-C", function() {
      beforeEach(function() {
        return grammar = atom.grammars.grammarForScopeName('source.objc');
      });
      it('parses the grammar', function() {
        expect(grammar).toBeTruthy();
        return expect(grammar.scopeName).toBe('source.objc');
      });
      return it('tokenizes classes', function() {
        var lines;
        lines = grammar.tokenizeLines('@interface Thing\n@property (nonatomic, strong) NSArray *items;\n@end');
        expect(lines[0][1]).toEqual({
          value: 'interface',
          scopes: ["source.objc", "meta.interface-or-protocol.objc", "storage.type.objc"]
        });
        return expect(lines[0][3]).toEqual({
          value: 'Thing',
          scopes: ["source.objc", "meta.interface-or-protocol.objc", "entity.name.type.objc"]
        });
      });
    });
    return describe("Objective-C++", function() {
      beforeEach(function() {
        return grammar = atom.grammars.grammarForScopeName('source.objcpp');
      });
      it('parses the grammar', function() {
        expect(grammar).toBeTruthy();
        return expect(grammar.scopeName).toBe('source.objcpp');
      });
      return it('tokenizes classes', function() {
        var lines;
        lines = grammar.tokenizeLines('class Thing1 {\n  vector<int> items;\n};\n\n@interface Thing2\n@property (nonatomic, strong) NSArray *items;\n@end');
        expect(lines[0][2].value).toBe('Thing1');
        return expect(lines[4][3]).toEqual({
          value: 'Thing2',
          scopes: ["source.objcpp", "meta.interface-or-protocol.objc", "entity.name.type.objc"]
        });
      });
    });
  });

}).call(this);
