(function() {
  describe("Perl 6 grammar", function() {
    var grammar;
    grammar = null;
    beforeEach(function() {
      waitsForPromise(function() {
        return atom.packages.activatePackage("language-perl");
      });
      return runs(function() {
        return grammar = atom.grammars.grammarForScopeName("source.perl6");
      });
    });
    it("parses the grammar", function() {
      expect(grammar).toBeDefined();
      return expect(grammar.scopeName).toBe("source.perl6");
    });
    describe("identifiers", function() {
      it("should match simple scalar identifiers", function() {
        var tokens;
        tokens = grammar.tokenizeLine('$a').tokens;
        return expect(tokens[0]).toEqual({
          value: '$a',
          scopes: ['source.perl6', 'variable.other.identifier.perl6']
        });
      });
      it("should match simple array identifiers", function() {
        var tokens;
        tokens = grammar.tokenizeLine('@a').tokens;
        return expect(tokens[0]).toEqual({
          value: '@a',
          scopes: ['source.perl6', 'variable.other.identifier.perl6']
        });
      });
      it("should match simple hash identifiers", function() {
        var tokens;
        tokens = grammar.tokenizeLine('%a').tokens;
        return expect(tokens[0]).toEqual({
          value: '%a',
          scopes: ['source.perl6', 'variable.other.identifier.perl6']
        });
      });
      it("should match simple hash identifiers", function() {
        var tokens;
        tokens = grammar.tokenizeLine('&a').tokens;
        return expect(tokens[0]).toEqual({
          value: '&a',
          scopes: ['source.perl6', 'variable.other.identifier.perl6']
        });
      });
      return it("should match unicode identifiers", function() {
        var tokens;
        tokens = grammar.tokenizeLine('$cööl-páttérn').tokens;
        return expect(tokens[0]).toEqual({
          value: '$cööl-páttérn',
          scopes: ['source.perl6', 'variable.other.identifier.perl6']
        });
      });
    });
    describe("strings", function() {
      return it("should tokenize simple strings", function() {
        var tokens;
        tokens = grammar.tokenizeLine('"abc"').tokens;
        expect(tokens.length).toEqual(3);
        expect(tokens[0]).toEqual({
          value: '"',
          scopes: ['source.perl6', 'string.quoted.double.perl6', 'punctuation.definition.string.begin.perl6']
        });
        expect(tokens[1]).toEqual({
          value: 'abc',
          scopes: ['source.perl6', 'string.quoted.double.perl6']
        });
        return expect(tokens[2]).toEqual({
          value: '"',
          scopes: ['source.perl6', 'string.quoted.double.perl6', 'punctuation.definition.string.end.perl6']
        });
      });
    });
    describe("modules", function() {
      return it("should parse package declarations", function() {
        var tokens;
        tokens = grammar.tokenizeLine("class Johnny's::Super-Cool::cööl-páttérn::Module").tokens;
        expect(tokens.length).toEqual(3);
        expect(tokens[0]).toEqual({
          value: 'class',
          scopes: ['source.perl6', 'meta.class.perl6', 'storage.type.class.perl6']
        });
        expect(tokens[1]).toEqual({
          value: ' ',
          scopes: ['source.perl6', 'meta.class.perl6']
        });
        return expect(tokens[2]).toEqual({
          value: 'Johnny\'s::Super-Cool::cööl-páttérn::Module',
          scopes: ['source.perl6', 'meta.class.perl6', 'entity.name.type.class.perl6']
        });
      });
    });
    return describe("comments", function() {
      return it("should parse comments", function() {
        var tokens;
        tokens = grammar.tokenizeLine("# this is the comment").tokens;
        expect(tokens.length).toEqual(3);
        expect(tokens[0]).toEqual({
          value: '#',
          scopes: ['source.perl6', 'comment.line.number-sign.perl6', 'punctuation.definition.comment.perl6']
        });
        return expect(tokens[1]).toEqual({
          value: ' this is the comment',
          scopes: ['source.perl6', 'comment.line.number-sign.perl6']
        });
      });
    });
  });

}).call(this);
