(function() {
  var TextEditor;

  TextEditor = require('atom').TextEditor;

  describe('PHP grammar', function() {
    var grammar;
    grammar = null;
    beforeEach(function() {
      waitsForPromise(function() {
        return atom.packages.activatePackage('language-php');
      });
      return runs(function() {
        return grammar = atom.grammars.grammarForScopeName('text.html.php');
      });
    });
    it('parses the grammar', function() {
      expect(grammar).toBeTruthy();
      return expect(grammar.scopeName).toBe('text.html.php');
    });
    return describe('operators', function() {
      it('should tokenize = correctly', function() {
        var tokens;
        tokens = grammar.tokenizeLines("<?php\n$test = 2;");
        expect(tokens[1][0]).toEqual({
          value: '$',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'variable.other.php', 'punctuation.definition.variable.php']
        });
        expect(tokens[1][2]).toEqual({
          value: ' ',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
        });
        expect(tokens[1][3]).toEqual({
          value: '=',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'keyword.operator.assignment.php']
        });
        expect(tokens[1][4]).toEqual({
          value: ' ',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
        });
        expect(tokens[1][5]).toEqual({
          value: '2',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'constant.numeric.php']
        });
        return expect(tokens[1][6]).toEqual({
          value: ';',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'punctuation.terminator.expression.php']
        });
      });
      it('should tokenize + correctly', function() {
        var tokens;
        tokens = grammar.tokenizeLines("<?php\n1 + 2;");
        expect(tokens[1][0]).toEqual({
          value: '1',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'constant.numeric.php']
        });
        expect(tokens[1][1]).toEqual({
          value: ' ',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
        });
        expect(tokens[1][2]).toEqual({
          value: '+',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'keyword.operator.arithmetic.php']
        });
        expect(tokens[1][3]).toEqual({
          value: ' ',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
        });
        expect(tokens[1][4]).toEqual({
          value: '2',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'constant.numeric.php']
        });
        return expect(tokens[1][5]).toEqual({
          value: ';',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'punctuation.terminator.expression.php']
        });
      });
      it('should tokenize - correctly', function() {
        var tokens;
        tokens = grammar.tokenizeLines("<?php\n1 - 2;");
        expect(tokens[1][0]).toEqual({
          value: '1',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'constant.numeric.php']
        });
        expect(tokens[1][1]).toEqual({
          value: ' ',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
        });
        expect(tokens[1][2]).toEqual({
          value: '-',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'keyword.operator.arithmetic.php']
        });
        expect(tokens[1][3]).toEqual({
          value: ' ',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
        });
        expect(tokens[1][4]).toEqual({
          value: '2',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'constant.numeric.php']
        });
        return expect(tokens[1][5]).toEqual({
          value: ';',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'punctuation.terminator.expression.php']
        });
      });
      it('should tokenize * correctly', function() {
        var tokens;
        tokens = grammar.tokenizeLines("<?php\n1 * 2;");
        expect(tokens[1][0]).toEqual({
          value: '1',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'constant.numeric.php']
        });
        expect(tokens[1][1]).toEqual({
          value: ' ',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
        });
        expect(tokens[1][2]).toEqual({
          value: '*',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'keyword.operator.arithmetic.php']
        });
        expect(tokens[1][3]).toEqual({
          value: ' ',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
        });
        expect(tokens[1][4]).toEqual({
          value: '2',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'constant.numeric.php']
        });
        return expect(tokens[1][5]).toEqual({
          value: ';',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'punctuation.terminator.expression.php']
        });
      });
      it('should tokenize / correctly', function() {
        var tokens;
        tokens = grammar.tokenizeLines("<?php\n1 / 2;");
        expect(tokens[1][0]).toEqual({
          value: '1',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'constant.numeric.php']
        });
        expect(tokens[1][1]).toEqual({
          value: ' ',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
        });
        expect(tokens[1][2]).toEqual({
          value: '/',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'keyword.operator.arithmetic.php']
        });
        expect(tokens[1][3]).toEqual({
          value: ' ',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
        });
        expect(tokens[1][4]).toEqual({
          value: '2',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'constant.numeric.php']
        });
        return expect(tokens[1][5]).toEqual({
          value: ';',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'punctuation.terminator.expression.php']
        });
      });
      it('should tokenize % correctly', function() {
        var tokens;
        tokens = grammar.tokenizeLines("<?php\n1 % 2;");
        expect(tokens[1][0]).toEqual({
          value: '1',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'constant.numeric.php']
        });
        expect(tokens[1][1]).toEqual({
          value: ' ',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
        });
        expect(tokens[1][2]).toEqual({
          value: '%',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'keyword.operator.arithmetic.php']
        });
        expect(tokens[1][3]).toEqual({
          value: ' ',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
        });
        expect(tokens[1][4]).toEqual({
          value: '2',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'constant.numeric.php']
        });
        return expect(tokens[1][5]).toEqual({
          value: ';',
          scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'punctuation.terminator.expression.php']
        });
      });
      return describe('combined operators', function() {
        it('should tokenize += correctly', function() {
          var tokens;
          tokens = grammar.tokenizeLines("<?php\n$test += 2;");
          expect(tokens[1][0]).toEqual({
            value: '$',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'variable.other.php', 'punctuation.definition.variable.php']
          });
          expect(tokens[1][1]).toEqual({
            value: 'test',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'variable.other.php']
          });
          expect(tokens[1][2]).toEqual({
            value: ' ',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
          });
          expect(tokens[1][3]).toEqual({
            value: '+=',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'keyword.operator.assignment.php']
          });
          expect(tokens[1][4]).toEqual({
            value: ' ',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
          });
          expect(tokens[1][5]).toEqual({
            value: '2',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'constant.numeric.php']
          });
          return expect(tokens[1][6]).toEqual({
            value: ';',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'punctuation.terminator.expression.php']
          });
        });
        it('should tokenize -= correctly', function() {
          var tokens;
          tokens = grammar.tokenizeLines("<?php\n$test -= 2;");
          expect(tokens[1][0]).toEqual({
            value: '$',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'variable.other.php', 'punctuation.definition.variable.php']
          });
          expect(tokens[1][1]).toEqual({
            value: 'test',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'variable.other.php']
          });
          expect(tokens[1][2]).toEqual({
            value: ' ',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
          });
          expect(tokens[1][3]).toEqual({
            value: '-=',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'keyword.operator.assignment.php']
          });
          expect(tokens[1][4]).toEqual({
            value: ' ',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
          });
          expect(tokens[1][5]).toEqual({
            value: '2',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'constant.numeric.php']
          });
          return expect(tokens[1][6]).toEqual({
            value: ';',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'punctuation.terminator.expression.php']
          });
        });
        it('should tokenize *= correctly', function() {
          var tokens;
          tokens = grammar.tokenizeLines("<?php\n$test *= 2;");
          expect(tokens[1][0]).toEqual({
            value: '$',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'variable.other.php', 'punctuation.definition.variable.php']
          });
          expect(tokens[1][1]).toEqual({
            value: 'test',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'variable.other.php']
          });
          expect(tokens[1][2]).toEqual({
            value: ' ',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
          });
          expect(tokens[1][3]).toEqual({
            value: '*=',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'keyword.operator.assignment.php']
          });
          expect(tokens[1][4]).toEqual({
            value: ' ',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
          });
          expect(tokens[1][5]).toEqual({
            value: '2',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'constant.numeric.php']
          });
          return expect(tokens[1][6]).toEqual({
            value: ';',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'punctuation.terminator.expression.php']
          });
        });
        it('should tokenize /= correctly', function() {
          var tokens;
          tokens = grammar.tokenizeLines("<?php\n$test /= 2;");
          expect(tokens[1][0]).toEqual({
            value: '$',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'variable.other.php', 'punctuation.definition.variable.php']
          });
          expect(tokens[1][1]).toEqual({
            value: 'test',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'variable.other.php']
          });
          expect(tokens[1][2]).toEqual({
            value: ' ',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
          });
          expect(tokens[1][3]).toEqual({
            value: '/=',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'keyword.operator.assignment.php']
          });
          expect(tokens[1][4]).toEqual({
            value: ' ',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
          });
          expect(tokens[1][5]).toEqual({
            value: '2',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'constant.numeric.php']
          });
          return expect(tokens[1][6]).toEqual({
            value: ';',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'punctuation.terminator.expression.php']
          });
        });
        it('should tokenize %= correctly', function() {
          var tokens;
          tokens = grammar.tokenizeLines("<?php\n$test %= 2;");
          expect(tokens[1][0]).toEqual({
            value: '$',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'variable.other.php', 'punctuation.definition.variable.php']
          });
          expect(tokens[1][1]).toEqual({
            value: 'test',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'variable.other.php']
          });
          expect(tokens[1][2]).toEqual({
            value: ' ',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
          });
          expect(tokens[1][3]).toEqual({
            value: '%=',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'keyword.operator.assignment.php']
          });
          expect(tokens[1][4]).toEqual({
            value: ' ',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
          });
          expect(tokens[1][5]).toEqual({
            value: '2',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'constant.numeric.php']
          });
          return expect(tokens[1][6]).toEqual({
            value: ';',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'punctuation.terminator.expression.php']
          });
        });
        it('should tokenize .= correctly', function() {
          var tokens;
          tokens = grammar.tokenizeLines("<?php\n$test .= 2;");
          expect(tokens[1][0]).toEqual({
            value: '$',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'variable.other.php', 'punctuation.definition.variable.php']
          });
          expect(tokens[1][1]).toEqual({
            value: 'test',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'variable.other.php']
          });
          expect(tokens[1][2]).toEqual({
            value: ' ',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
          });
          expect(tokens[1][3]).toEqual({
            value: '.=',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'keyword.operator.string.php']
          });
          expect(tokens[1][4]).toEqual({
            value: ' ',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
          });
          expect(tokens[1][5]).toEqual({
            value: '2',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'constant.numeric.php']
          });
          return expect(tokens[1][6]).toEqual({
            value: ';',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'punctuation.terminator.expression.php']
          });
        });
        it('should tokenize &= correctly', function() {
          var tokens;
          tokens = grammar.tokenizeLines("<?php\n$test &= 2;");
          expect(tokens[1][0]).toEqual({
            value: '$',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'variable.other.php', 'punctuation.definition.variable.php']
          });
          expect(tokens[1][1]).toEqual({
            value: 'test',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'variable.other.php']
          });
          expect(tokens[1][2]).toEqual({
            value: ' ',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
          });
          expect(tokens[1][3]).toEqual({
            value: '&=',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'keyword.operator.assignment.php']
          });
          expect(tokens[1][4]).toEqual({
            value: ' ',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
          });
          expect(tokens[1][5]).toEqual({
            value: '2',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'constant.numeric.php']
          });
          return expect(tokens[1][6]).toEqual({
            value: ';',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'punctuation.terminator.expression.php']
          });
        });
        it('should tokenize |= correctly', function() {
          var tokens;
          tokens = grammar.tokenizeLines("<?php\n$test |= 2;");
          expect(tokens[1][0]).toEqual({
            value: '$',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'variable.other.php', 'punctuation.definition.variable.php']
          });
          expect(tokens[1][1]).toEqual({
            value: 'test',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'variable.other.php']
          });
          expect(tokens[1][2]).toEqual({
            value: ' ',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
          });
          expect(tokens[1][3]).toEqual({
            value: '|=',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'keyword.operator.assignment.php']
          });
          expect(tokens[1][4]).toEqual({
            value: ' ',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
          });
          expect(tokens[1][5]).toEqual({
            value: '2',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'constant.numeric.php']
          });
          return expect(tokens[1][6]).toEqual({
            value: ';',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'punctuation.terminator.expression.php']
          });
        });
        it('should tokenize ^= correctly', function() {
          var tokens;
          tokens = grammar.tokenizeLines("<?php\n$test ^= 2;");
          expect(tokens[1][0]).toEqual({
            value: '$',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'variable.other.php', 'punctuation.definition.variable.php']
          });
          expect(tokens[1][1]).toEqual({
            value: 'test',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'variable.other.php']
          });
          expect(tokens[1][2]).toEqual({
            value: ' ',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
          });
          expect(tokens[1][3]).toEqual({
            value: '^=',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'keyword.operator.assignment.php']
          });
          expect(tokens[1][4]).toEqual({
            value: ' ',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
          });
          expect(tokens[1][5]).toEqual({
            value: '2',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'constant.numeric.php']
          });
          return expect(tokens[1][6]).toEqual({
            value: ';',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'punctuation.terminator.expression.php']
          });
        });
        it('should tokenize <<= correctly', function() {
          var tokens;
          tokens = grammar.tokenizeLines("<?php\n$test <<= 2;");
          expect(tokens[1][0]).toEqual({
            value: '$',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'variable.other.php', 'punctuation.definition.variable.php']
          });
          expect(tokens[1][1]).toEqual({
            value: 'test',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'variable.other.php']
          });
          expect(tokens[1][2]).toEqual({
            value: ' ',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
          });
          expect(tokens[1][3]).toEqual({
            value: '<<=',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'keyword.operator.assignment.php']
          });
          expect(tokens[1][4]).toEqual({
            value: ' ',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
          });
          expect(tokens[1][5]).toEqual({
            value: '2',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'constant.numeric.php']
          });
          return expect(tokens[1][6]).toEqual({
            value: ';',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'punctuation.terminator.expression.php']
          });
        });
        return it('should tokenize >>= correctly', function() {
          var tokens;
          tokens = grammar.tokenizeLines("<?php\n$test >>= 2;");
          expect(tokens[1][0]).toEqual({
            value: '$',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'variable.other.php', 'punctuation.definition.variable.php']
          });
          expect(tokens[1][1]).toEqual({
            value: 'test',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'variable.other.php']
          });
          expect(tokens[1][2]).toEqual({
            value: ' ',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
          });
          expect(tokens[1][3]).toEqual({
            value: '>>=',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'keyword.operator.assignment.php']
          });
          expect(tokens[1][4]).toEqual({
            value: ' ',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php']
          });
          expect(tokens[1][5]).toEqual({
            value: '2',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'constant.numeric.php']
          });
          return expect(tokens[1][6]).toEqual({
            value: ';',
            scopes: ['text.html.php', 'meta.embedded.block.php', 'source.php', 'punctuation.terminator.expression.php']
          });
        });
      });
    });
  });

}).call(this);
