(function() {
  describe('SCSS grammar', function() {
    var grammar;
    grammar = null;
    beforeEach(function() {
      waitsForPromise(function() {
        return atom.packages.activatePackage('language-sass');
      });
      return runs(function() {
        return grammar = atom.grammars.grammarForScopeName('source.css.scss');
      });
    });
    it('parses the grammar', function() {
      var sassGrammar, scssGrammar;
      sassGrammar = atom.grammars.grammarForScopeName('source.sass');
      expect(sassGrammar).toBeTruthy();
      expect(sassGrammar.scopeName).toBe('source.sass');
      scssGrammar = atom.grammars.grammarForScopeName('source.css.scss');
      expect(scssGrammar).toBeTruthy();
      return expect(scssGrammar.scopeName).toBe('source.css.scss');
    });
    describe('@at-root', function() {
      return it('tokenizes it correctly', function() {
        var tokens;
        tokens = grammar.tokenizeLine('@at-root (without: media) .btn { color: red; }').tokens;
        expect(tokens[0]).toEqual({
          value: '@',
          scopes: ['source.css.scss', 'meta.at-rule.at-root.scss', 'keyword.control.at-rule.at-root.scss', 'punctuation.definition.keyword.scss']
        });
        return expect(tokens[1]).toEqual({
          value: 'at-root',
          scopes: ['source.css.scss', 'meta.at-rule.at-root.scss', 'keyword.control.at-rule.at-root.scss']
        });
      });
    });
    describe('@page', function() {
      return it('tokenizes it correctly', function() {
        var lines;
        lines = grammar.tokenizeLines("@page {\n  text-align: center;\n}");
        expect(lines[0][0]).toEqual({
          value: '@',
          scopes: ['source.css.scss', 'meta.at-rule.page.scss', 'keyword.control.at-rule.page.scss', 'punctuation.definition.keyword.scss']
        });
        expect(lines[0][1]).toEqual({
          value: 'page',
          scopes: ['source.css.scss', 'meta.at-rule.page.scss', 'keyword.control.at-rule.page.scss']
        });
        expect(lines[1][0]).toEqual({
          value: '  ',
          scopes: ['source.css.scss', 'meta.property-list.scss']
        });
        expect(lines[1][1]).toEqual({
          value: 'text-align',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-name.scss', 'support.type.property-name.scss']
        });
        expect(lines[1][2]).toEqual({
          value: ':',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-value.scss', 'punctuation.separator.key-value.scss']
        });
        expect(lines[1][3]).toEqual({
          value: ' ',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-value.scss']
        });
        expect(lines[1][4]).toEqual({
          value: 'center',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-value.scss', 'support.constant.property-value.scss']
        });
        lines = grammar.tokenizeLines("@page :left {\n  text-align: center;\n}");
        expect(lines[0][0]).toEqual({
          value: '@',
          scopes: ['source.css.scss', 'meta.at-rule.page.scss', 'keyword.control.at-rule.page.scss', 'punctuation.definition.keyword.scss']
        });
        expect(lines[0][1]).toEqual({
          value: 'page',
          scopes: ['source.css.scss', 'meta.at-rule.page.scss', 'keyword.control.at-rule.page.scss']
        });
        expect(lines[0][2]).toEqual({
          value: ' ',
          scopes: ['source.css.scss', 'meta.at-rule.page.scss']
        });
        expect(lines[0][3]).toEqual({
          value: ':left',
          scopes: ['source.css.scss', 'meta.at-rule.page.scss', 'entity.name.function.scss']
        });
        expect(lines[1][0]).toEqual({
          value: '  ',
          scopes: ['source.css.scss', 'meta.property-list.scss']
        });
        expect(lines[1][1]).toEqual({
          value: 'text-align',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-name.scss', 'support.type.property-name.scss']
        });
        expect(lines[1][2]).toEqual({
          value: ':',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-value.scss', 'punctuation.separator.key-value.scss']
        });
        expect(lines[1][3]).toEqual({
          value: ' ',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-value.scss']
        });
        expect(lines[1][4]).toEqual({
          value: 'center',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-value.scss', 'support.constant.property-value.scss']
        });
        lines = grammar.tokenizeLines("@page:left {\n  text-align: center;\n}");
        expect(lines[0][0]).toEqual({
          value: '@',
          scopes: ['source.css.scss', 'meta.at-rule.page.scss', 'keyword.control.at-rule.page.scss', 'punctuation.definition.keyword.scss']
        });
        expect(lines[0][1]).toEqual({
          value: 'page',
          scopes: ['source.css.scss', 'meta.at-rule.page.scss', 'keyword.control.at-rule.page.scss']
        });
        expect(lines[0][2]).toEqual({
          value: ':left',
          scopes: ['source.css.scss', 'meta.at-rule.page.scss', 'entity.name.function.scss']
        });
        expect(lines[1][0]).toEqual({
          value: '  ',
          scopes: ['source.css.scss', 'meta.property-list.scss']
        });
        expect(lines[1][1]).toEqual({
          value: 'text-align',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-name.scss', 'support.type.property-name.scss']
        });
        expect(lines[1][2]).toEqual({
          value: ':',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-value.scss', 'punctuation.separator.key-value.scss']
        });
        expect(lines[1][3]).toEqual({
          value: ' ',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-value.scss']
        });
        return expect(lines[1][4]).toEqual({
          value: 'center',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-value.scss', 'support.constant.property-value.scss']
        });
      });
    });
    describe('property names with a prefix that matches an element name', function() {
      return it('does not confuse them with properties', function() {
        var lines;
        lines = grammar.tokenizeLines("text {\n  text-align: center;\n}");
        expect(lines[0][0]).toEqual({
          value: 'text',
          scopes: ['source.css.scss', 'entity.name.tag.scss']
        });
        expect(lines[1][0]).toEqual({
          value: '  ',
          scopes: ['source.css.scss', 'meta.property-list.scss']
        });
        expect(lines[1][1]).toEqual({
          value: 'text-align',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-name.scss', 'support.type.property-name.scss']
        });
        expect(lines[1][2]).toEqual({
          value: ':',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-value.scss', 'punctuation.separator.key-value.scss']
        });
        expect(lines[1][3]).toEqual({
          value: ' ',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-value.scss']
        });
        expect(lines[1][4]).toEqual({
          value: 'center',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-value.scss', 'support.constant.property-value.scss']
        });
        lines = grammar.tokenizeLines("table {\n  table-layout: fixed;\n}");
        expect(lines[0][0]).toEqual({
          value: 'table',
          scopes: ['source.css.scss', 'entity.name.tag.scss']
        });
        expect(lines[1][0]).toEqual({
          value: '  ',
          scopes: ['source.css.scss', 'meta.property-list.scss']
        });
        expect(lines[1][1]).toEqual({
          value: 'table-layout',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-name.scss', 'support.type.property-name.scss']
        });
        expect(lines[1][2]).toEqual({
          value: ':',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-value.scss', 'punctuation.separator.key-value.scss']
        });
        expect(lines[1][3]).toEqual({
          value: ' ',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-value.scss']
        });
        return expect(lines[1][4]).toEqual({
          value: 'fixed',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-value.scss', 'support.constant.property-value.scss']
        });
      });
    });
    describe('vendor properties', function() {
      return it('tokenizes the browser prefix', function() {
        var tokens;
        tokens = grammar.tokenizeLine('body { -webkit-box-shadow: none; }').tokens;
        expect(tokens[0]).toEqual({
          value: 'body',
          scopes: ['source.css.scss', 'entity.name.tag.scss']
        });
        return expect(tokens[4]).toEqual({
          value: '-webkit-box-shadow',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-name.scss', 'support.type.property-name.scss']
        });
      });
    });
    describe('custom elements', function() {
      it('tokenizes them as tags', function() {
        var tokens;
        tokens = grammar.tokenizeLine('very-custom { color: red; }').tokens;
        expect(tokens[0]).toEqual({
          value: 'very-custom',
          scopes: ['source.css.scss', 'entity.name.tag.custom.scss']
        });
        tokens = grammar.tokenizeLine('very-very-custom { color: red; }').tokens;
        return expect(tokens[0]).toEqual({
          value: 'very-very-custom',
          scopes: ['source.css.scss', 'entity.name.tag.custom.scss']
        });
      });
      it('tokenizes them with pseudo selectors', function() {
        var tokens;
        tokens = grammar.tokenizeLine('very-custom:hover { color: red; }').tokens;
        expect(tokens[0]).toEqual({
          value: 'very-custom',
          scopes: ['source.css.scss', 'entity.name.tag.custom.scss']
        });
        expect(tokens[1]).toEqual({
          value: ':',
          scopes: ['source.css.scss', 'entity.other.attribute-name.pseudo-class.css', 'punctuation.definition.entity.css']
        });
        return expect(tokens[2]).toEqual({
          value: 'hover',
          scopes: ['source.css.scss', 'entity.other.attribute-name.pseudo-class.css']
        });
      });
      it('tokenizes them with class selectors', function() {
        var tokens;
        tokens = grammar.tokenizeLine('very-custom.class { color: red; }').tokens;
        expect(tokens[0]).toEqual({
          value: 'very-custom',
          scopes: ['source.css.scss', 'entity.name.tag.custom.scss']
        });
        expect(tokens[1]).toEqual({
          value: '.',
          scopes: ['source.css.scss', 'entity.other.attribute-name.class.css', 'punctuation.definition.entity.css']
        });
        return expect(tokens[2]).toEqual({
          value: 'class',
          scopes: ['source.css.scss', 'entity.other.attribute-name.class.css']
        });
      });
      return it('does not confuse them with properties', function() {
        var lines;
        lines = grammar.tokenizeLines("body {\n  border-width: 2;\n  font-size : 2;\n  background-image  : none;\n}");
        expect(lines[1][0]).toEqual({
          value: '  ',
          scopes: ['source.css.scss', 'meta.property-list.scss']
        });
        expect(lines[1][1]).toEqual({
          value: 'border-width',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-name.scss', 'support.type.property-name.scss']
        });
        expect(lines[1][2]).toEqual({
          value: ':',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-value.scss', 'punctuation.separator.key-value.scss']
        });
        expect(lines[1][3]).toEqual({
          value: ' ',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-value.scss']
        });
        expect(lines[1][4]).toEqual({
          value: '2',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-value.scss', 'constant.numeric.scss']
        });
        expect(lines[2][0]).toEqual({
          value: '  ',
          scopes: ['source.css.scss', 'meta.property-list.scss']
        });
        expect(lines[2][1]).toEqual({
          value: 'font-size',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-name.scss', 'support.type.property-name.scss']
        });
        expect(lines[2][2]).toEqual({
          value: ' ',
          scopes: ['source.css.scss', 'meta.property-list.scss']
        });
        expect(lines[2][3]).toEqual({
          value: ':',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-value.scss', 'punctuation.separator.key-value.scss']
        });
        expect(lines[2][4]).toEqual({
          value: ' ',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-value.scss']
        });
        expect(lines[2][5]).toEqual({
          value: '2',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-value.scss', 'constant.numeric.scss']
        });
        expect(lines[3][0]).toEqual({
          value: '  ',
          scopes: ['source.css.scss', 'meta.property-list.scss']
        });
        expect(lines[3][1]).toEqual({
          value: 'background-image',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-name.scss', 'support.type.property-name.scss']
        });
        expect(lines[3][2]).toEqual({
          value: '  ',
          scopes: ['source.css.scss', 'meta.property-list.scss']
        });
        expect(lines[3][3]).toEqual({
          value: ':',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-value.scss', 'punctuation.separator.key-value.scss']
        });
        expect(lines[3][4]).toEqual({
          value: ' ',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-value.scss']
        });
        return expect(lines[3][5]).toEqual({
          value: 'none',
          scopes: ['source.css.scss', 'meta.property-list.scss', 'meta.property-value.scss', 'support.constant.property-value.scss']
        });
      });
    });
    describe("pseudo selectors", function() {
      return it("parses the value of the argument correctly", function() {
        var tokens;
        tokens = grammar.tokenizeLine('div:nth-child(3n+0) { color: red; }').tokens;
        expect(tokens[0]).toEqual({
          value: 'div',
          scopes: ['source.css.scss', 'entity.name.tag.scss']
        });
        expect(tokens[1]).toEqual({
          value: ':',
          scopes: ['source.css.scss', 'entity.other.attribute-name.pseudo-class.css', 'punctuation.definition.entity.css']
        });
        expect(tokens[2]).toEqual({
          value: 'nth-child(3n+0)',
          scopes: ['source.css.scss', 'entity.other.attribute-name.pseudo-class.css']
        });
        tokens = grammar.tokenizeLine('div:nth-child(2n-1) { color: red; }').tokens;
        expect(tokens[0]).toEqual({
          value: 'div',
          scopes: ['source.css.scss', 'entity.name.tag.scss']
        });
        expect(tokens[1]).toEqual({
          value: ':',
          scopes: ['source.css.scss', 'entity.other.attribute-name.pseudo-class.css', 'punctuation.definition.entity.css']
        });
        return expect(tokens[2]).toEqual({
          value: 'nth-child(2n-1)',
          scopes: ['source.css.scss', 'entity.other.attribute-name.pseudo-class.css']
        });
      });
    });
    return describe("keyframes", function() {
      return it("parses the from and to properties", function() {
        var lines;
        lines = grammar.tokenizeLines("@keyframes anim {\nfrom { opacity: 0; }\nto { opacity: 1; }\n}");
        expect(lines[0][0]).toEqual({
          value: '@',
          scopes: ['source.css.scss', 'meta.at-rule.keyframes.scss', 'keyword.control.at-rule.keyframes.scss', 'punctuation.definition.keyword.scss']
        });
        expect(lines[0][1]).toEqual({
          value: 'keyframes',
          scopes: ['source.css.scss', 'meta.at-rule.keyframes.scss', 'keyword.control.at-rule.keyframes.scss']
        });
        expect(lines[0][2]).toEqual({
          value: ' ',
          scopes: ['source.css.scss', 'meta.at-rule.keyframes.scss']
        });
        expect(lines[0][3]).toEqual({
          value: 'anim',
          scopes: ['source.css.scss', 'meta.at-rule.keyframes.scss', 'entity.name.function.scss']
        });
        expect(lines[1][0]).toEqual({
          value: 'from',
          scopes: ['source.css.scss', 'meta.at-rule.keyframes.scss', 'meta.keyframes.scss', 'entity.other.attribute-name.scss']
        });
        expect(lines[1][4]).toEqual({
          value: 'opacity',
          scopes: ['source.css.scss', 'meta.at-rule.keyframes.scss', 'meta.keyframes.scss', 'meta.property-list.scss', 'meta.property-name.scss', 'support.type.property-name.scss']
        });
        expect(lines[1][7]).toEqual({
          value: '0',
          scopes: ['source.css.scss', 'meta.at-rule.keyframes.scss', 'meta.keyframes.scss', 'meta.property-list.scss', 'meta.property-value.scss', 'constant.numeric.scss']
        });
        expect(lines[2][0]).toEqual({
          value: 'to',
          scopes: ['source.css.scss', 'meta.at-rule.keyframes.scss', 'meta.keyframes.scss', 'entity.other.attribute-name.scss']
        });
        expect(lines[2][4]).toEqual({
          value: 'opacity',
          scopes: ['source.css.scss', 'meta.at-rule.keyframes.scss', 'meta.keyframes.scss', 'meta.property-list.scss', 'meta.property-name.scss', 'support.type.property-name.scss']
        });
        return expect(lines[2][7]).toEqual({
          value: '1',
          scopes: ['source.css.scss', 'meta.at-rule.keyframes.scss', 'meta.keyframes.scss', 'meta.property-list.scss', 'meta.property-value.scss', 'constant.numeric.scss']
        });
      });
    });
  });

}).call(this);
