(function() {
  describe("Shell session grammar", function() {
    var grammar;
    grammar = null;
    beforeEach(function() {
      waitsForPromise(function() {
        return atom.packages.activatePackage("language-shellscript");
      });
      return runs(function() {
        return grammar = atom.grammars.grammarForScopeName("text.shell-session");
      });
    });
    it("parses the grammar", function() {
      expect(grammar).toBeDefined();
      return expect(grammar.scopeName).toBe("text.shell-session");
    });
    it("tokenizes > prompts", function() {
      var tokens;
      tokens = grammar.tokenizeLines('> echo $FOO');
      expect(tokens[0][0].value).toBe('>');
      expect(tokens[0][0].scopes).toEqual(['text.shell-session', 'punctuation.separator.prompt.shell-session']);
      expect(tokens[0][1].value).toBe(' ');
      expect(tokens[0][1].scopes).toEqual(['text.shell-session']);
      expect(tokens[0][2].value).toBe('echo');
      return expect(tokens[0][2].scopes).toEqual(['text.shell-session', 'support.function.builtin.shell']);
    });
    it("tokenizes $ prompts", function() {
      var tokens;
      tokens = grammar.tokenizeLines('$ echo $FOO');
      expect(tokens[0][0].value).toBe('$');
      expect(tokens[0][0].scopes).toEqual(['text.shell-session', 'punctuation.separator.prompt.shell-session']);
      expect(tokens[0][1].value).toBe(' ');
      expect(tokens[0][1].scopes).toEqual(['text.shell-session']);
      expect(tokens[0][2].value).toBe('echo');
      return expect(tokens[0][2].scopes).toEqual(['text.shell-session', 'support.function.builtin.shell']);
    });
    it("tokenizes pound prompts", function() {
      var tokens;
      tokens = grammar.tokenizeLines('# echo $FOO');
      expect(tokens[0][0].value).toBe('#');
      expect(tokens[0][0].scopes).toEqual(['text.shell-session', 'punctuation.separator.prompt.shell-session']);
      expect(tokens[0][1].value).toBe(' ');
      expect(tokens[0][1].scopes).toEqual(['text.shell-session']);
      expect(tokens[0][2].value).toBe('echo');
      return expect(tokens[0][2].scopes).toEqual(['text.shell-session', 'support.function.builtin.shell']);
    });
    it("tokenizes % prompts", function() {
      var tokens;
      tokens = grammar.tokenizeLines('% echo $FOO');
      expect(tokens[0][0].value).toBe('%');
      expect(tokens[0][0].scopes).toEqual(['text.shell-session', 'punctuation.separator.prompt.shell-session']);
      expect(tokens[0][1].value).toBe(' ');
      expect(tokens[0][1].scopes).toEqual(['text.shell-session']);
      expect(tokens[0][2].value).toBe('echo');
      return expect(tokens[0][2].scopes).toEqual(['text.shell-session', 'support.function.builtin.shell']);
    });
    it("tokenizes prompts with prefixes", function() {
      var tokens;
      tokens = grammar.tokenizeLines('user@machine $ echo $FOO');
      expect(tokens[0][0].value).toBe('user@machine');
      expect(tokens[0][0].scopes).toEqual(['text.shell-session', 'entity.other.prompt-prefix.shell-session']);
      expect(tokens[0][1].value).toBe(' ');
      expect(tokens[0][1].scopes).toEqual(['text.shell-session']);
      expect(tokens[0][2].value).toBe('$');
      expect(tokens[0][2].scopes).toEqual(['text.shell-session', 'punctuation.separator.prompt.shell-session']);
      expect(tokens[0][3].value).toBe(' ');
      expect(tokens[0][3].scopes).toEqual(['text.shell-session']);
      expect(tokens[0][4].value).toBe('echo');
      return expect(tokens[0][4].scopes).toEqual(['text.shell-session', 'support.function.builtin.shell']);
    });
    return it("tokenizes shell output", function() {
      var tokens;
      tokens = grammar.tokenizeLines('$ echo $FOO\nfoo');
      expect(tokens[1][0].value).toBe('foo');
      return expect(tokens[1][0].scopes).toEqual(['text.shell-session', 'meta.output.shell-session']);
    });
  });

}).call(this);
