(function() {
  describe("TOML grammar", function() {
    var grammar;
    grammar = null;
    beforeEach(function() {
      waitsForPromise(function() {
        return atom.packages.activatePackage("language-toml");
      });
      return runs(function() {
        return grammar = atom.grammars.grammarForScopeName('source.toml');
      });
    });
    it("parses the grammar", function() {
      expect(grammar).toBeTruthy();
      return expect(grammar.scopeName).toBe("source.toml");
    });
    it("tokenizes comments", function() {
      var tokens;
      tokens = grammar.tokenizeLine("# I am a comment").tokens;
      return expect(tokens[0]).toEqual({
        value: "# I am a comment",
        scopes: ["source.toml", "comment.toml"]
      });
    });
    it("tokenizes strings", function() {
      var tokens;
      tokens = grammar.tokenizeLine('"I am a string"').tokens;
      expect(tokens[0]).toEqual({
        value: '"',
        scopes: ["source.toml", "string.toml", "string.begin.toml"]
      });
      expect(tokens[1]).toEqual({
        value: 'I am a string',
        scopes: ["source.toml", "string.toml"]
      });
      expect(tokens[2]).toEqual({
        value: '"',
        scopes: ["source.toml", "string.toml", "string.end.toml"]
      });
      tokens = grammar.tokenizeLine('"I\'m \\n escaped"').tokens;
      expect(tokens[0]).toEqual({
        value: '"',
        scopes: ["source.toml", "string.toml", "string.begin.toml"]
      });
      expect(tokens[1]).toEqual({
        value: "I'm ",
        scopes: ["source.toml", "string.toml"]
      });
      expect(tokens[2]).toEqual({
        value: "\\n",
        scopes: ["source.toml", "string.toml", "constant.character.escape.toml"]
      });
      expect(tokens[3]).toEqual({
        value: " escaped",
        scopes: ["source.toml", "string.toml"]
      });
      return expect(tokens[4]).toEqual({
        value: '"',
        scopes: ["source.toml", "string.toml", "string.end.toml"]
      });
    });
    it("tokenizes booleans", function() {
      var tokens;
      tokens = grammar.tokenizeLine("true").tokens;
      expect(tokens[0]).toEqual({
        value: "true",
        scopes: ["source.toml", "constant.language.boolean.true.toml"]
      });
      tokens = grammar.tokenizeLine("false").tokens;
      return expect(tokens[0]).toEqual({
        value: "false",
        scopes: ["source.toml", "constant.language.boolean.false.toml"]
      });
    });
    it("tokenizes numbers", function() {
      var tokens;
      tokens = grammar.tokenizeLine("123").tokens;
      expect(tokens[0]).toEqual({
        value: "123",
        scopes: ["source.toml", "constant.numeric.toml"]
      });
      tokens = grammar.tokenizeLine("-1").tokens;
      expect(tokens[0]).toEqual({
        value: "-1",
        scopes: ["source.toml", "constant.numeric.toml"]
      });
      tokens = grammar.tokenizeLine("3.14").tokens;
      expect(tokens[0]).toEqual({
        value: "3.14",
        scopes: ["source.toml", "constant.numeric.toml"]
      });
      tokens = grammar.tokenizeLine("-123.456").tokens;
      return expect(tokens[0]).toEqual({
        value: "-123.456",
        scopes: ["source.toml", "constant.numeric.toml"]
      });
    });
    it("tokenizes dates", function() {
      var tokens;
      tokens = grammar.tokenizeLine("1979-05-27T07:32:00Z").tokens;
      return expect(tokens[0]).toEqual({
        value: "1979-05-27T07:32:00Z",
        scopes: ["source.toml", "support.date.toml"]
      });
    });
    it("tokenizes keygroups", function() {
      var tokens;
      tokens = grammar.tokenizeLine("[keygroup]").tokens;
      expect(tokens[0]).toEqual({
        value: "[",
        scopes: ["source.toml", "keygroup.toml"]
      });
      expect(tokens[1]).toEqual({
        value: "keygroup",
        scopes: ["source.toml", "keygroup.toml", "variable.keygroup.toml"]
      });
      return expect(tokens[2]).toEqual({
        value: "]",
        scopes: ["source.toml", "keygroup.toml"]
      });
    });
    it("tokenizes keygroup arrays", function() {
      var tokens;
      tokens = grammar.tokenizeLine("[[keygroup]]").tokens;
      expect(tokens[0]).toEqual({
        value: "[[",
        scopes: ["source.toml", "keygroup.toml"]
      });
      expect(tokens[1]).toEqual({
        value: "keygroup",
        scopes: ["source.toml", "keygroup.toml", "variable.keygroup.array.toml"]
      });
      return expect(tokens[2]).toEqual({
        value: "]]",
        scopes: ["source.toml", "keygroup.toml"]
      });
    });
    return it("tokenizes keys", function() {
      var tokens;
      tokens = grammar.tokenizeLine("key =").tokens;
      expect(tokens[0]).toEqual({
        value: "key",
        scopes: ["source.toml", "key.toml", "entity.key.toml"]
      });
      return expect(tokens[1]).toEqual({
        value: " =",
        scopes: ["source.toml", "key.toml"]
      });
    });
  });

}).call(this);
