(function() {
  var shell;

  shell = require('shell');

  describe("link package", function() {
    beforeEach(function() {
      waitsForPromise(function() {
        return atom.packages.activatePackage('language-gfm');
      });
      waitsForPromise(function() {
        return atom.packages.activatePackage('language-javascript');
      });
      waitsForPromise(function() {
        return atom.packages.activatePackage('language-hyperlink');
      });
      return waitsForPromise(function() {
        var activationPromise;
        activationPromise = atom.packages.activatePackage('link');
        atom.commands.dispatch(atom.views.getView(atom.workspace), 'link:open');
        return activationPromise;
      });
    });
    return describe("when the cursor is on a link", function() {
      it("opens the link using the 'open' command", function() {
        waitsForPromise(function() {
          return atom.workspace.open('sample.js');
        });
        return runs(function() {
          var editor;
          editor = atom.workspace.getActiveTextEditor();
          editor.setText("// \"http://github.com\"");
          spyOn(shell, 'openExternal');
          atom.commands.dispatch(atom.views.getView(editor), 'link:open');
          expect(shell.openExternal).not.toHaveBeenCalled();
          editor.setCursorBufferPosition([0, 4]);
          atom.commands.dispatch(atom.views.getView(editor), 'link:open');
          expect(shell.openExternal).toHaveBeenCalled();
          expect(shell.openExternal.argsForCall[0][0]).toBe('http://github.com');
          shell.openExternal.reset();
          editor.setCursorBufferPosition([0, 8]);
          atom.commands.dispatch(atom.views.getView(editor), 'link:open');
          expect(shell.openExternal).toHaveBeenCalled();
          expect(shell.openExternal.argsForCall[0][0]).toBe('http://github.com');
          shell.openExternal.reset();
          editor.setCursorBufferPosition([0, 21]);
          atom.commands.dispatch(atom.views.getView(editor), 'link:open');
          expect(shell.openExternal).toHaveBeenCalled();
          return expect(shell.openExternal.argsForCall[0][0]).toBe('http://github.com');
        });
      });
      describe("when the cursor is on a [name][url-name] style markdown link", function() {
        return it("opens the named url", function() {
          waitsForPromise(function() {
            return atom.workspace.open('README.md');
          });
          return runs(function() {
            var editor;
            editor = atom.workspace.getActiveTextEditor();
            editor.setText("you should [click][here]\nyou should not [click][her]\n\n[here]: http://github.com");
            spyOn(shell, 'openExternal');
            editor.setCursorBufferPosition([0, 0]);
            atom.commands.dispatch(atom.views.getView(editor), 'link:open');
            expect(shell.openExternal).not.toHaveBeenCalled();
            editor.setCursorBufferPosition([0, 20]);
            atom.commands.dispatch(atom.views.getView(editor), 'link:open');
            expect(shell.openExternal).toHaveBeenCalled();
            expect(shell.openExternal.argsForCall[0][0]).toBe('http://github.com');
            shell.openExternal.reset();
            editor.setCursorBufferPosition([1, 24]);
            atom.commands.dispatch(atom.views.getView(editor), 'link:open');
            return expect(shell.openExternal).not.toHaveBeenCalled();
          });
        });
      });
      return it("does not open non http/https links", function() {
        waitsForPromise(function() {
          return atom.workspace.open('sample.js');
        });
        return runs(function() {
          var editor;
          editor = atom.workspace.getActiveTextEditor();
          editor.setText("// ftp://github.com\n");
          spyOn(shell, 'openExternal');
          atom.commands.dispatch(atom.views.getView(editor), 'link:open');
          expect(shell.openExternal).not.toHaveBeenCalled();
          editor.setCursorBufferPosition([0, 5]);
          atom.commands.dispatch(atom.views.getView(editor), 'link:open');
          return expect(shell.openExternal).not.toHaveBeenCalled();
        });
      });
    });
  });

}).call(this);
