(function() {
  var CompositeDisposable, Notification, Notifications, _ref;

  _ref = require('atom'), Notification = _ref.Notification, CompositeDisposable = _ref.CompositeDisposable;

  Notifications = {
    isInitialized: false,
    subscriptions: null,
    duplicateTimeDelay: 500,
    lastNotification: null,
    config: {
      showErrorsInDevMode: {
        type: 'boolean',
        "default": false
      }
    },
    activate: function(state) {
      var CommandLogger, notification, _i, _len, _ref1;
      CommandLogger = require('./command-logger');
      CommandLogger.start();
      this.subscriptions = new CompositeDisposable;
      _ref1 = atom.notifications.getNotifications();
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        notification = _ref1[_i];
        this.addNotificationView(notification);
      }
      this.subscriptions.add(atom.notifications.onDidAddNotification((function(_this) {
        return function(notification) {
          return _this.addNotificationView(notification);
        };
      })(this)));
      this.subscriptions.add(atom.onWillThrowError(function(_arg) {
        var line, match, message, options, originalError, preventDefault, url;
        message = _arg.message, url = _arg.url, line = _arg.line, originalError = _arg.originalError, preventDefault = _arg.preventDefault;
        if (originalError.name === 'BufferedProcessError') {
          message = message.replace('Uncaught BufferedProcessError: ', '');
          return atom.notifications.addError(message, {
            dismissable: true
          });
        } else if (originalError.code === 'ENOENT' && !/\/atom/i.test(message) && (match = /spawn (.+) ENOENT/.exec(message))) {
          message = "'" + match[1] + "' could not be spawned.\nIs it installed and on your path?\nIf so please open an issue on the package spawning the process.";
          return atom.notifications.addError(message, {
            dismissable: true
          });
        } else if (!atom.inDevMode() || atom.config.get('notifications.showErrorsInDevMode')) {
          preventDefault();
          options = {
            detail: "" + url + ":" + line,
            stack: originalError.stack,
            dismissable: true
          };
          return atom.notifications.addFatalError(message, options);
        }
      }));
      return this.subscriptions.add(atom.commands.add('atom-workspace', 'core:cancel', function() {
        var _j, _len1, _ref2, _results;
        _ref2 = atom.notifications.getNotifications();
        _results = [];
        for (_j = 0, _len1 = _ref2.length; _j < _len1; _j++) {
          notification = _ref2[_j];
          _results.push(notification.dismiss());
        }
        return _results;
      }));
    },
    deactivate: function() {
      var _ref1, _ref2;
      this.subscriptions.dispose();
      if ((_ref1 = this.notificationsElement) != null) {
        _ref1.remove();
      }
      if ((_ref2 = this.notificationsPanel) != null) {
        _ref2.destroy();
      }
      this.subscriptions = null;
      this.notificationsElement = null;
      this.notificationsPanel = null;
      return this.isInitialized = false;
    },
    initializeIfNotInitialized: function() {
      var NotificationElement, NotificationsElement;
      if (this.isInitialized) {
        return;
      }
      NotificationsElement = require('./notifications-element');
      NotificationElement = require('./notification-element');
      this.subscriptions.add(atom.views.addViewProvider(Notification, function(model) {
        return new NotificationElement().initialize(model);
      }));
      this.notificationsElement = new NotificationsElement;
      atom.views.getView(atom.workspace).appendChild(this.notificationsElement);
      return this.isInitialized = true;
    },
    togglePanel: function() {
      var NotificationsPanelView;
      if (this.notificationsPanel != null) {
        if (Notifications.notificationsPanel.isVisible()) {
          return Notifications.notificationsPanel.hide();
        } else {
          return Notifications.notificationsPanel.show();
        }
      } else {
        NotificationsPanelView = require('./notifications-panel-view');
        Notifications.notificationsPanelView = new NotificationsPanelView;
        return Notifications.notificationsPanel = atom.workspace.addBottomPanel({
          item: Notifications.notificationsPanelView.getElement()
        });
      }
    },
    addNotificationView: function(notification) {
      var timeSpan;
      this.initializeIfNotInitialized();
      if (notification.wasDisplayed()) {
        return;
      }
      if (this.lastNotification != null) {
        timeSpan = notification.getTimestamp() - this.lastNotification.getTimestamp();
        if (!(timeSpan < this.duplicateTimeDelay && notification.isEqual(this.lastNotification))) {
          this.notificationsElement.appendChild(atom.views.getView(notification));
        }
      } else {
        this.notificationsElement.appendChild(atom.views.getView(notification));
      }
      notification.setDisplayed(true);
      return this.lastNotification = notification;
    }
  };

  if (atom.inDevMode()) {
    atom.commands.add('atom-workspace', 'notifications:toggle-dev-panel', function() {
      return Notifications.togglePanel();
    });
    atom.commands.add('atom-workspace', 'notifications:trigger-error', function() {
      var error, options;
      try {
        return abc + 2;
      } catch (_error) {
        error = _error;
        options = {
          detail: error.stack.split('\n')[1],
          stack: error.stack,
          dismissable: true
        };
        return atom.notifications.addFatalError("Uncaught " + (error.stack.split('\n')[0]), options);
      }
    });
  }

  module.exports = Notifications;

}).call(this);
