(function() {
  var NotificationsPanelView,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  module.exports = NotificationsPanelView = (function() {
    function NotificationsPanelView() {
      this.createSuccess = __bind(this.createSuccess, this);
      this.createInfo = __bind(this.createInfo, this);
      this.createWarning = __bind(this.createWarning, this);
      this.createError = __bind(this.createError, this);
      this.createFatalError = __bind(this.createFatalError, this);
      var errorButton, fatalErrorButton, infoButton, successButton, toolbar, warningButton;
      this.element = document.createElement('div');
      this.element.classList.add('notifications');
      this.element.classList.add('padded');
      toolbar = document.createElement('div');
      toolbar.classList.add('btn-toolbar');
      this.element.appendChild(toolbar);
      fatalErrorButton = document.createElement('button');
      fatalErrorButton.classList.add('btn');
      fatalErrorButton.textContent = "Create Fatal Error";
      fatalErrorButton.addEventListener('click', this.createFatalError);
      toolbar.appendChild(fatalErrorButton);
      errorButton = document.createElement('button');
      errorButton.classList.add('btn');
      errorButton.textContent = "Create Error";
      errorButton.addEventListener('click', this.createError);
      toolbar.appendChild(errorButton);
      warningButton = document.createElement('button');
      warningButton.classList.add('btn');
      warningButton.textContent = "Create Warning";
      warningButton.addEventListener('click', this.createWarning);
      toolbar.appendChild(warningButton);
      infoButton = document.createElement('button');
      infoButton.classList.add('btn');
      infoButton.textContent = "Create Info Notification";
      infoButton.addEventListener('click', this.createInfo);
      toolbar.appendChild(infoButton);
      successButton = document.createElement('button');
      successButton.classList.add('btn');
      successButton.textContent = "Create Success Notification";
      successButton.addEventListener('click', this.createSuccess);
      toolbar.appendChild(successButton);
    }

    NotificationsPanelView.prototype.getElement = function() {
      return this.element;
    };

    NotificationsPanelView.prototype.createFatalError = function() {
      return atom.commands.dispatch(atom.views.getView(atom.workspace), 'notifications:trigger-error');
    };

    NotificationsPanelView.prototype.createError = function() {
      var message, options;
      message = 'Failed to load your user config';
      options = {
        dismissable: true,
        detail: "line 6: unexpected newline\n'metrics'::\n^"
      };
      return atom.notifications.addError(message, options);
    };

    NotificationsPanelView.prototype.createWarning = function() {
      return atom.notifications.addWarning('Oops warning');
    };

    NotificationsPanelView.prototype.createInfo = function() {
      return atom.notifications.addInfo('Some info for you', {
        icon: 'comment'
      });
    };

    NotificationsPanelView.prototype.createSuccess = function() {
      return atom.notifications.addSuccess('Yeah, success!');
    };

    return NotificationsPanelView;

  })();

}).call(this);
