(function() {
  var GitHubFile, getActivePath, getSelectedRange;

  GitHubFile = require('./github-file');

  module.exports = {
    config: {
      includeLineNumbersInUrls: {
        "default": true,
        type: 'boolean'
      }
    },
    activate: function() {
      return atom.commands.add('atom-pane', {
        'open-on-github:file': function() {
          var itemPath;
          if (itemPath = getActivePath()) {
            return GitHubFile.fromPath(itemPath).open(getSelectedRange());
          }
        },
        'open-on-github:blame': function() {
          var itemPath;
          if (itemPath = getActivePath()) {
            return GitHubFile.fromPath(itemPath).blame(getSelectedRange());
          }
        },
        'open-on-github:history': function() {
          var itemPath;
          if (itemPath = getActivePath()) {
            return GitHubFile.fromPath(itemPath).history();
          }
        },
        'open-on-github:copy-url': function() {
          var itemPath;
          if (itemPath = getActivePath()) {
            return GitHubFile.fromPath(itemPath).copyUrl(getSelectedRange());
          }
        },
        'open-on-github:branch-compare': function() {
          var itemPath;
          if (itemPath = getActivePath()) {
            return GitHubFile.fromPath(itemPath).openBranchCompare();
          }
        },
        'open-on-github:repository': function() {
          var itemPath;
          if (itemPath = getActivePath()) {
            return GitHubFile.fromPath(itemPath).openRepository();
          }
        }
      });
    }
  };

  getActivePath = function() {
    var _ref;
    return (_ref = atom.workspace.getActivePaneItem()) != null ? typeof _ref.getPath === "function" ? _ref.getPath() : void 0 : void 0;
  };

  getSelectedRange = function() {
    var _ref;
    return (_ref = atom.workspace.getActivePaneItem()) != null ? typeof _ref.getSelectedBufferRange === "function" ? _ref.getSelectedBufferRange() : void 0 : void 0;
  };

}).call(this);
