(function() {
  var $, BufferedProcess, PackageGeneratorView, TextEditorView, View, fs, path, _, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  path = require('path');

  _ = require('underscore-plus');

  _ref = require('atom-space-pen-views'), $ = _ref.$, TextEditorView = _ref.TextEditorView, View = _ref.View;

  BufferedProcess = require('atom').BufferedProcess;

  fs = require('fs-plus');

  module.exports = PackageGeneratorView = (function(_super) {
    __extends(PackageGeneratorView, _super);

    function PackageGeneratorView() {
      return PackageGeneratorView.__super__.constructor.apply(this, arguments);
    }

    PackageGeneratorView.prototype.previouslyFocusedElement = null;

    PackageGeneratorView.prototype.mode = null;

    PackageGeneratorView.content = function() {
      return this.div({
        "class": 'package-generator'
      }, (function(_this) {
        return function() {
          _this.subview('miniEditor', new TextEditorView({
            mini: true
          }));
          _this.div({
            "class": 'error',
            outlet: 'error'
          });
          return _this.div({
            "class": 'message',
            outlet: 'message'
          });
        };
      })(this));
    };

    PackageGeneratorView.prototype.initialize = function() {
      this.commandSubscription = atom.commands.add('atom-workspace', {
        'package-generator:generate-package': (function(_this) {
          return function() {
            return _this.attach('package');
          };
        })(this),
        'package-generator:generate-syntax-theme': (function(_this) {
          return function() {
            return _this.attach('theme');
          };
        })(this)
      });
      this.miniEditor.on('blur', (function(_this) {
        return function() {
          return _this.close();
        };
      })(this));
      return atom.commands.add(this.element, {
        'core:confirm': (function(_this) {
          return function() {
            return _this.confirm();
          };
        })(this),
        'core:cancel': (function(_this) {
          return function() {
            return _this.close();
          };
        })(this)
      });
    };

    PackageGeneratorView.prototype.destroy = function() {
      var _ref1;
      if ((_ref1 = this.panel) != null) {
        _ref1.destroy();
      }
      return this.commandSubscription.dispose();
    };

    PackageGeneratorView.prototype.attach = function(mode) {
      this.mode = mode;
      if (this.panel == null) {
        this.panel = atom.workspace.addModalPanel({
          item: this,
          visible: false
        });
      }
      this.previouslyFocusedElement = $(document.activeElement);
      this.panel.show();
      this.message.text("Enter " + mode + " path");
      if (this.mode === 'package') {
        this.setPathText("my-package");
      } else {
        this.setPathText("my-theme-syntax", [0, 8]);
      }
      return this.miniEditor.focus();
    };

    PackageGeneratorView.prototype.setPathText = function(placeholderName, rangeToSelect) {
      var editor, endOfDirectoryIndex, packagesDirectory, pathLength;
      editor = this.miniEditor.getModel();
      if (rangeToSelect == null) {
        rangeToSelect = [0, placeholderName.length];
      }
      packagesDirectory = this.getPackagesDirectory();
      editor.setText(path.join(packagesDirectory, placeholderName));
      pathLength = editor.getText().length;
      endOfDirectoryIndex = pathLength - placeholderName.length;
      return editor.setSelectedBufferRange([[0, endOfDirectoryIndex + rangeToSelect[0]], [0, endOfDirectoryIndex + rangeToSelect[1]]]);
    };

    PackageGeneratorView.prototype.close = function() {
      var _ref1;
      if (!this.panel.isVisible()) {
        return;
      }
      this.panel.hide();
      return (_ref1 = this.previouslyFocusedElement) != null ? _ref1.focus() : void 0;
    };

    PackageGeneratorView.prototype.confirm = function() {
      if (this.validPackagePath()) {
        return this.createPackageFiles((function(_this) {
          return function() {
            var packagePath;
            packagePath = _this.getPackagePath();
            atom.open({
              pathsToOpen: [packagePath]
            });
            return _this.close();
          };
        })(this));
      }
    };

    PackageGeneratorView.prototype.getPackagePath = function() {
      var packageName, packagePath;
      packagePath = this.miniEditor.getText();
      packageName = _.dasherize(path.basename(packagePath));
      return path.join(path.dirname(packagePath), packageName);
    };

    PackageGeneratorView.prototype.getPackagesDirectory = function() {
      return atom.config.get('core.projectHome') || process.env.ATOM_REPOS_HOME || path.join(fs.getHomeDirectory(), 'github');
    };

    PackageGeneratorView.prototype.validPackagePath = function() {
      if (fs.existsSync(this.getPackagePath())) {
        this.error.text("Path already exists at '" + (this.getPackagePath()) + "'");
        this.error.show();
        return false;
      } else {
        return true;
      }
    };

    PackageGeneratorView.prototype.initPackage = function(packagePath, callback) {
      return this.runCommand(atom.packages.getApmPath(), ['init', "--" + this.mode, "" + packagePath], callback);
    };

    PackageGeneratorView.prototype.linkPackage = function(packagePath, callback) {
      var args;
      args = ['link'];
      if (atom.config.get('package-generator.createInDevMode')) {
        args.push('--dev');
      }
      args.push(packagePath.toString());
      return this.runCommand(atom.packages.getApmPath(), args, callback);
    };

    PackageGeneratorView.prototype.isStoredInDotAtom = function(packagePath) {
      var devPackagesPath, packagesPath;
      packagesPath = path.join(atom.getConfigDirPath(), 'packages', path.sep);
      if (packagePath.indexOf(packagesPath) === 0) {
        return true;
      }
      devPackagesPath = path.join(atom.getConfigDirPath(), 'dev', 'packages', path.sep);
      return packagePath.indexOf(devPackagesPath) === 0;
    };

    PackageGeneratorView.prototype.createPackageFiles = function(callback) {
      var packagePath, packagesDirectory;
      packagePath = this.getPackagePath();
      packagesDirectory = this.getPackagesDirectory();
      if (this.isStoredInDotAtom(packagePath)) {
        return this.initPackage(packagePath, callback);
      } else {
        return this.initPackage(packagePath, (function(_this) {
          return function() {
            return _this.linkPackage(packagePath, callback);
          };
        })(this));
      }
    };

    PackageGeneratorView.prototype.runCommand = function(command, args, exit) {
      return new BufferedProcess({
        command: command,
        args: args,
        exit: exit
      });
    };

    return PackageGeneratorView;

  })(View);

}).call(this);
