(function() {
  var ChunkedLineReader, Readable, fs, isBinaryFile, lastIndexOf,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  fs = require("fs");

  isBinaryFile = require("isbinaryfile");

  Readable = require('stream').Readable;

  lastIndexOf = function(buffer, length, char) {
    var i;
    i = length;
    while (i--) {
      if (buffer[i] === char) {
        return i;
      }
    }
    return -1;
  };

  module.exports = ChunkedLineReader = (function(_super) {
    __extends(ChunkedLineReader, _super);

    ChunkedLineReader.CHUNK_SIZE = 10240;

    ChunkedLineReader.chunkedBuffer = null;

    ChunkedLineReader.headerBuffer = new Buffer(256);

    function ChunkedLineReader(filePath) {
      this.filePath = filePath;
      ChunkedLineReader.__super__.constructor.call(this);
    }

    ChunkedLineReader.prototype.isBinaryFile = function() {
      var fd, isBin;
      fd = fs.openSync(this.filePath, "r");
      isBin = isBinaryFile(this.constructor.headerBuffer, fs.readSync(fd, this.constructor.headerBuffer, 0, 256));
      fs.closeSync(fd);
      return isBin;
    };

    ChunkedLineReader.prototype._read = function() {
      var bytesRead, char, chunkSize, chunkedBuffer, fd, index, line, newRemainder, offset, remainder, str, _base;
      try {
        fd = fs.openSync(this.filePath, "r");
        line = 0;
        offset = 0;
        remainder = '';
        chunkSize = this.constructor.CHUNK_SIZE;
        if (isBinaryFile(this.constructor.headerBuffer, fs.readSync(fd, this.constructor.headerBuffer, 0, 256))) {
          return;
        }
        if ((_base = this.constructor).chunkedBuffer == null) {
          _base.chunkedBuffer = new Buffer(chunkSize);
        }
        chunkedBuffer = this.constructor.chunkedBuffer;
        bytesRead = fs.readSync(fd, chunkedBuffer, 0, chunkSize, 0);
        while (bytesRead) {
          char = 10;
          index = lastIndexOf(chunkedBuffer, bytesRead, char);
          if (index < 0) {
            newRemainder = chunkedBuffer.toString("utf8", 0, bytesRead);
            str = null;
          } else if (index > -1 && index === bytesRead - 1) {
            newRemainder = '';
            str = chunkedBuffer.toString("utf8", 0, bytesRead);
          } else {
            newRemainder = chunkedBuffer.toString("utf8", index + 1, bytesRead);
            str = chunkedBuffer.toString("utf8", 0, index + 1);
          }
          if (str) {
            if (remainder) {
              str = remainder + str;
            }
            this.push(str);
            remainder = newRemainder;
          } else {
            remainder = remainder + newRemainder;
          }
          offset += bytesRead;
          bytesRead = fs.readSync(fd, chunkedBuffer, 0, chunkSize, offset);
        }
        if (remainder) {
          return this.push(remainder);
        }
      } finally {
        if (fd != null) {
          fs.closeSync(fd);
        }
        this.push(null);
      }
    };

    return ChunkedLineReader;

  })(Readable);

}).call(this);
