(function() {
  var ChunkedExecutor, ChunkedScanner,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  ChunkedExecutor = require('./chunked-executor');

  module.exports = ChunkedScanner = (function(_super) {
    __extends(ChunkedScanner, _super);

    function ChunkedScanner(scanner, execPathFn) {
      this.scanner = scanner;
      this.onFinishedScanning = __bind(this.onFinishedScanning, this);
      this.finishedScanning = false;
      ChunkedScanner.__super__.constructor.call(this, [], execPathFn);
    }

    ChunkedScanner.prototype.execute = function(doneCallback) {
      ChunkedScanner.__super__.execute.call(this, doneCallback);
      this.scanner.on('path-found', this.push);
      this.scanner.on('finished-scanning', this.onFinishedScanning);
      return this.scanner.scan();
    };

    ChunkedScanner.prototype.onFinishedScanning = function() {
      this.finishedScanning = true;
      return this.checkIfFinished();
    };

    ChunkedScanner.prototype.checkIfFinished = function() {
      var isFinished;
      if (!this.finishedScanning) {
        return false;
      }
      isFinished = ChunkedScanner.__super__.checkIfFinished.call(this);
      if (isFinished) {
        this.scanner.removeListener('path-found', this.path);
        this.scanner.removeListener('finished-scanning', this.onFinishedScanning);
      }
      return isFinished;
    };

    return ChunkedScanner;

  })(ChunkedExecutor);

}).call(this);
