(function() {
  var ArgumentParser, PathReplacer, PathScanner, PathSearcher, SingleProcess, main, path, replace, search, singleProcessReplaceMain, singleProcessScanMain, singleProcessSearchMain, _;

  _ = require('underscore');

  ArgumentParser = require('argparse').ArgumentParser;

  PathSearcher = require('./path-searcher');

  PathScanner = require('./path-scanner');

  PathReplacer = require('./path-replacer');

  path = require("path");

  SingleProcess = require('./single-process-search');

  search = SingleProcess.search, replace = SingleProcess.replace;

  singleProcessScanMain = SingleProcess.scanMain;

  singleProcessSearchMain = SingleProcess.searchMain;

  singleProcessReplaceMain = SingleProcess.replaceMain;

  /*
  This CLI is mainly for benchmarking. While there may be useful data output to
  the console, it will probably change. The options will probably change as
  well.
  */


  main = function() {
    var argParser, options;
    argParser = new ArgumentParser({
      version: require('../package.json').version,
      addHelp: true,
      description: 'List paths, search, and replace in a directory'
    });
    argParser.addArgument(['-m', '--multiprocess'], {
      action: 'storeTrue'
    });
    argParser.addArgument(['-e', '--excludeVcsIgnores'], {
      action: 'storeTrue'
    });
    argParser.addArgument(['-o', '--verbose'], {
      action: 'storeTrue'
    });
    argParser.addArgument(['-d', '--dryReplace'], {
      action: 'storeTrue'
    });
    argParser.addArgument(['-s', '--search']);
    argParser.addArgument(['-r', '--replace']);
    argParser.addArgument(['pathToScan']);
    options = argParser.parseArgs();
    if (options.search && options.replace) {
      return singleProcessReplaceMain(options);
    } else if (options.search) {
      if (options.multiprocess) {
        return require('./multi-process-search').searchMain(options);
      } else {
        return singleProcessSearchMain(options);
      }
    } else {
      return singleProcessScanMain(options);
    }
  };

  module.exports = {
    main: main,
    search: search,
    replace: replace,
    PathSearcher: PathSearcher,
    PathScanner: PathScanner,
    PathReplacer: PathReplacer
  };

}).call(this);
