module.exports = Observer

var assert = require('asserts')
var fn = require('fn')

function Observer() {
  this._spies = {}
}

Observer.prototype.on = function (obj, prop) {
  var props = Array.prototype.slice.call(arguments, 1)
  var method = fn.foldl(props, function (a, b) { return a[b] }, obj)

  var spies = this._spies
  var uniqueId = prop + String(Object.keys(this._spies).length)

  spies[uniqueId] = null

  obj[prop] = function () {
    spies[uniqueId] = Array.prototype.slice.call(arguments, 0)
    method.apply(obj, arguments)
  }

  return {
    assert: function (args) {
      args = Array.prototype.slice.call(arguments, 1)
      assert(spies[uniqueId] !== null, prop + ' was not called')
      if (args.length) {
        assert.deepEqual(spies[uniqueId], args, 'Arguments do not match')
      }
    }
  }
}
