(function() {
  var CompileToolsErrorView, ErrorView, View,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  View = require('atom-space-pen-views').View;

  CompileToolsErrorView = require('./compile-tools-error-view');

  module.exports = ErrorView = (function(_super) {
    __extends(ErrorView, _super);

    function ErrorView() {
      return ErrorView.__super__.constructor.apply(this, arguments);
    }

    ErrorView.content = function() {
      return this.div({
        "class": 'error-message'
      }, (function(_this) {
        return function() {
          return _this.div({
            outlet: 'alert',
            "class": 'alert alert-danger alert-dismissable native-key-bindings',
            tabindex: -1
          }, function() {
            _this.button({
              outlet: 'close',
              "class": 'close icon icon-x'
            });
            _this.span({
              outlet: 'message',
              "class": 'native-key-bindings'
            });
            _this.a({
              outlet: 'detailsLink',
              "class": 'alert-link error-link'
            }, 'Show output\u2026');
            return _this.div({
              outlet: 'detailsArea',
              "class": 'padded'
            }, function() {
              return _this.pre({
                outlet: 'details',
                "class": 'error-details text'
              });
            });
          });
        };
      })(this));
    };

    ErrorView.prototype.initialize = function(packageManager, _arg) {
      var message, packageInstallError, stderr;
      this.packageManager = packageManager;
      message = _arg.message, stderr = _arg.stderr, packageInstallError = _arg.packageInstallError;
      this.message.text(message);
      this.detailsArea.hide();
      this.details.text(stderr);
      this.detailsLink.on('click', (function(_this) {
        return function() {
          if (_this.detailsArea.isHidden()) {
            _this.detailsArea.show();
            _this.detailsLink.text('Hide output\u2026');
          } else {
            _this.detailsArea.hide();
            _this.detailsLink.text('Show output\u2026');
          }
          return false;
        };
      })(this));
      this.close.on('click', (function(_this) {
        return function() {
          return _this.remove();
        };
      })(this));
      if (packageInstallError) {
        return this.checkForNativeBuildTools();
      }
    };

    ErrorView.prototype.checkForNativeBuildTools = function() {
      if (process.platform !== 'win32') {
        return;
      }
      return this.packageManager.checkNativeBuildTools()["catch"]((function(_this) {
        return function(error) {
          return _this.alert.append(new CompileToolsErrorView(error));
        };
      })(this));
    };

    return ErrorView;

  })(View);

}).call(this);
