(function() {
  var $, $$, Client, ErrorView, InstallPanel, PackageCard, PackageManager, Subscriber, TextEditorView, View, fs, path, _, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  path = require('path');

  _ = require('underscore-plus');

  fs = require('fs-plus');

  _ref = require('atom-space-pen-views'), $ = _ref.$, $$ = _ref.$$, TextEditorView = _ref.TextEditorView, View = _ref.View;

  Subscriber = require('emissary').Subscriber;

  PackageCard = require('./package-card');

  Client = require('./atom-io-client');

  ErrorView = require('./error-view');

  PackageManager = require('./package-manager');

  module.exports = InstallPanel = (function(_super) {
    __extends(InstallPanel, _super);

    function InstallPanel() {
      return InstallPanel.__super__.constructor.apply(this, arguments);
    }

    Subscriber.includeInto(InstallPanel);

    InstallPanel.content = function() {
      return this.div((function(_this) {
        return function() {
          _this.div({
            "class": 'section packages'
          }, function() {
            return _this.div({
              "class": 'section-container'
            }, function() {
              _this.h1({
                outlet: 'installHeading',
                "class": 'section-heading icon icon-cloud-download'
              }, 'Install Packages');
              _this.div({
                "class": 'text native-key-bindings',
                tabindex: -1
              }, function() {
                _this.span({
                  "class": 'icon icon-question'
                });
                _this.span({
                  outlet: 'publishedToText'
                }, 'Packages are published to ');
                _this.a({
                  "class": 'link',
                  outlet: "openAtomIo"
                }, "atom.io");
                return _this.span(" and are installed to " + (path.join(fs.getHomeDirectory(), '.atom', 'packages')));
              });
              _this.div({
                "class": 'search-container clearfix'
              }, function() {
                _this.div({
                  "class": 'editor-container'
                }, function() {
                  return _this.subview('searchEditorView', new TextEditorView({
                    mini: true
                  }));
                });
                return _this.div({
                  "class": 'btn-group'
                }, function() {
                  _this.button({
                    outlet: 'searchPackagesButton',
                    "class": 'btn btn-default selected'
                  }, 'Packages');
                  return _this.button({
                    outlet: 'searchThemesButton',
                    "class": 'btn btn-default'
                  }, 'Themes');
                });
              });
              _this.div({
                outlet: 'searchErrors'
              });
              _this.div({
                outlet: 'searchMessage',
                "class": 'alert alert-info search-message icon icon-search'
              });
              return _this.div({
                outlet: 'resultsContainer',
                "class": 'container package-container'
              });
            });
          });
          return _this.div({
            "class": 'section packages'
          }, function() {
            return _this.div({
              "class": 'section-container'
            }, function() {
              _this.div({
                outlet: 'featuredHeading',
                "class": 'section-heading icon icon-star'
              });
              _this.div({
                outlet: 'featuredErrors'
              });
              _this.div({
                outlet: 'loadingMessage',
                "class": 'alert alert-info featured-message icon icon-hourglass'
              });
              return _this.div({
                outlet: 'featuredContainer',
                "class": 'container package-container'
              });
            });
          });
        };
      })(this));
    };

    InstallPanel.prototype.initialize = function(packageManager) {
      var client, _ref1;
      this.packageManager = packageManager;
      client = (_ref1 = $('.settings-view').view()) != null ? _ref1.client : void 0;
      this.client = this.packageManager.getClient();
      this.atomIoURL = 'https://atom.io/packages';
      this.openAtomIo.on('click', (function(_this) {
        return function() {
          require('shell').openExternal(_this.atomIoURL);
          return false;
        };
      })(this));
      this.searchMessage.hide();
      this.searchEditorView.getModel().setPlaceholderText('Search packages');
      this.searchType = 'packages';
      this.handleSearchEvents();
      return this.loadFeaturedPackages();
    };

    InstallPanel.prototype.detached = function() {
      return this.unsubscribe();
    };

    InstallPanel.prototype.focus = function() {
      return this.searchEditorView.focus();
    };

    InstallPanel.prototype.handleSearchEvents = function() {
      this.subscribe(this.packageManager, 'package-install-failed', (function(_this) {
        return function(pack, error) {
          return _this.searchErrors.append(new ErrorView(_this.packageManager, error));
        };
      })(this));
      this.subscribe(atom.commands.add(this.searchEditorView.element, 'core:confirm', (function(_this) {
        return function() {
          return _this.performSearch();
        };
      })(this)));
      this.searchPackagesButton.on('click', (function(_this) {
        return function() {
          if (!_this.searchPackagesButton.hasClass('selected')) {
            _this.searchType = 'packages';
            _this.searchPackagesButton.addClass('selected');
            _this.searchThemesButton.removeClass('selected');
            _this.searchEditorView.getModel().setPlaceholderText('Search packages');
            _this.publishedToText.text('Packages are published to ');
            _this.atomIoURL = 'https://atom.io/packages';
            _this.loadFeaturedPackages();
            return _this.performSearch();
          }
        };
      })(this));
      return this.searchThemesButton.on('click', (function(_this) {
        return function() {
          if (!_this.searchThemesButton.hasClass('selected')) {
            _this.searchType = 'themes';
            _this.searchThemesButton.addClass('selected');
            _this.searchPackagesButton.removeClass('selected');
            _this.searchEditorView.getModel().setPlaceholderText('Search themes');
            _this.publishedToText.text('Themes are published to ');
            _this.atomIoURL = 'https://atom.io/themes';
            _this.loadFeaturedPackages(true);
            return _this.performSearch();
          }
        };
      })(this));
    };

    InstallPanel.prototype.performSearch = function() {
      var query;
      if (query = this.searchEditorView.getText().trim()) {
        return this.search(query);
      }
    };

    InstallPanel.prototype.search = function(query) {
      var opts;
      this.resultsContainer.empty();
      this.searchMessage.text("Searching " + this.searchType + " for \u201C" + query + "\u201D\u2026").show();
      opts = {};
      opts[this.searchType] = true;
      return this.packageManager.search(query, opts).then((function(_this) {
        return function(packages) {
          if (packages == null) {
            packages = [];
          }
          if (packages.length === 0) {
            _this.searchMessage.text("No " + (_this.searchType.replace(/s$/, '')) + " results for \u201C" + query + "\u201D").show();
          } else {
            _this.searchMessage.hide();
          }
          return _this.addPackageViews(_this.resultsContainer, packages);
        };
      })(this))["catch"]((function(_this) {
        return function(error) {
          _this.searchMessage.hide();
          return _this.searchErrors.append(new ErrorView(_this.packageManager, error));
        };
      })(this));
    };

    InstallPanel.prototype.addPackageViews = function(container, packages) {
      var index, pack, packageRow, _i, _len, _results;
      container.empty();
      _results = [];
      for (index = _i = 0, _len = packages.length; _i < _len; index = ++_i) {
        pack = packages[index];
        packageRow = $$(function() {
          return this.div({
            "class": 'row'
          });
        });
        container.append(packageRow);
        _results.push(packageRow.append(new PackageCard(pack, this.packageManager, {
          back: 'Install'
        })));
      }
      return _results;
    };

    InstallPanel.prototype.filterPackages = function(packages, themes) {
      return packages.filter(function(_arg) {
        var theme;
        theme = _arg.theme;
        if (themes) {
          return theme;
        } else {
          return !theme;
        }
      });
    };

    InstallPanel.prototype.loadFeaturedPackages = function(loadThemes) {
      var handle;
      if (loadThemes == null) {
        loadThemes = false;
      }
      this.featuredContainer.empty();
      if (loadThemes) {
        this.installHeading.text('Install Themes');
        this.featuredHeading.text('Featured Themes');
        this.loadingMessage.text('Loading featured themes\u2026');
      } else {
        this.installHeading.text('Install Packages');
        this.featuredHeading.text('Featured Packages');
        this.loadingMessage.text('Loading featured packages\u2026');
      }
      this.loadingMessage.show();
      handle = (function(_this) {
        return function(error) {
          _this.loadingMessage.hide();
          return _this.featuredErrors.append(new ErrorView(_this.packageManager, error));
        };
      })(this);
      if (loadThemes) {
        return this.client.featuredThemes((function(_this) {
          return function(error, themes) {
            if (error) {
              return handle(error);
            } else {
              _this.loadingMessage.hide();
              _this.featuredHeading.text('Featured Themes');
              return _this.addPackageViews(_this.featuredContainer, themes);
            }
          };
        })(this));
      } else {
        return this.client.featuredPackages((function(_this) {
          return function(error, packages) {
            if (error) {
              return handle(error);
            } else {
              _this.loadingMessage.hide();
              _this.featuredHeading.text('Featured Packages');
              return _this.addPackageViews(_this.featuredContainer, packages);
            }
          };
        })(this));
      }
    };

    return InstallPanel;

  })(View);

}).call(this);
