(function() {
  var $$, ErrorView, InstalledPackagesPanel, PackageCard, Subscriber, TextEditorView, View, fuzzaldrin, _, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  _ = require('underscore-plus');

  _ref = require('atom-space-pen-views'), $$ = _ref.$$, TextEditorView = _ref.TextEditorView, View = _ref.View;

  Subscriber = require('emissary').Subscriber;

  fuzzaldrin = require('fuzzaldrin');

  PackageCard = require('./package-card');

  ErrorView = require('./error-view');

  module.exports = InstalledPackagesPanel = (function(_super) {
    __extends(InstalledPackagesPanel, _super);

    function InstalledPackagesPanel() {
      return InstalledPackagesPanel.__super__.constructor.apply(this, arguments);
    }

    Subscriber.includeInto(InstalledPackagesPanel);

    InstalledPackagesPanel.content = function() {
      return this.div((function(_this) {
        return function() {
          return _this.section({
            "class": 'section'
          }, function() {
            return _this.div({
              "class": 'section-container'
            }, function() {
              _this.div({
                "class": 'section-heading icon icon-package'
              }, function() {
                _this.text('Installed Packages');
                return _this.span({
                  outlet: 'totalPackages',
                  "class": 'section-heading-count badge badge-flexible'
                }, '…');
              });
              _this.div({
                "class": 'editor-container'
              }, function() {
                return _this.subview('filterEditor', new TextEditorView({
                  mini: true,
                  placeholderText: 'Filter packages by name'
                }));
              });
              _this.div({
                outlet: 'updateErrors'
              });
              _this.section({
                "class": 'sub-section installed-packages'
              }, function() {
                _this.h3({
                  "class": 'sub-section-heading icon icon-package'
                }, function() {
                  _this.text('Community Packages');
                  return _this.span({
                    outlet: 'communityCount',
                    "class": 'section-heading-count badge badge-flexible'
                  }, '…');
                });
                return _this.div({
                  outlet: 'communityPackages',
                  "class": 'container package-container'
                }, function() {
                  return _this.div({
                    "class": 'alert alert-info loading-area icon icon-hourglass'
                  }, "Loading packages…");
                });
              });
              _this.section({
                "class": 'sub-section core-packages'
              }, function() {
                _this.h3({
                  "class": 'sub-section-heading icon icon-package'
                }, function() {
                  _this.text('Core Packages');
                  return _this.span({
                    outlet: 'coreCount',
                    "class": 'section-heading-count badge badge-flexible'
                  }, '…');
                });
                return _this.div({
                  outlet: 'corePackages',
                  "class": 'container package-container'
                }, function() {
                  return _this.div({
                    "class": 'alert alert-info loading-area icon icon-hourglass'
                  }, "Loading packages…");
                });
              });
              return _this.section({
                "class": 'sub-section dev-packages'
              }, function() {
                _this.h3({
                  "class": 'sub-section-heading icon icon-package'
                }, function() {
                  _this.text('Development Packages');
                  return _this.span({
                    outlet: 'devCount',
                    "class": 'section-heading-count badge badge-flexible'
                  }, '…');
                });
                return _this.div({
                  outlet: 'devPackages',
                  "class": 'container package-container'
                }, function() {
                  return _this.div({
                    "class": 'alert alert-info loading-area icon icon-hourglass'
                  }, "Loading packages…");
                });
              });
            });
          });
        };
      })(this));
    };

    InstalledPackagesPanel.prototype.initialize = function(packageManager) {
      this.packageManager = packageManager;
      this.packageViews = [];
      this.subscribe(this.packageManager, 'package-install-failed theme-install-failed package-uninstall-failed theme-uninstall-failed package-update-failed theme-update-failed', (function(_this) {
        return function(pack, error) {
          return _this.updateErrors.append(new ErrorView(_this.packageManager, error));
        };
      })(this));
      this.filterEditor.getModel().onDidStopChanging((function(_this) {
        return function() {
          return _this.matchPackages();
        };
      })(this));
      return this.loadPackages();
    };

    InstalledPackagesPanel.prototype.focus = function() {
      return this.filterEditor.focus();
    };

    InstalledPackagesPanel.prototype.detached = function() {
      return this.unsubscribe();
    };

    InstalledPackagesPanel.prototype.filterPackages = function(packages) {
      packages.dev = packages.dev.filter(function(_arg) {
        var theme;
        theme = _arg.theme;
        return !theme;
      });
      packages.user = packages.user.filter(function(_arg) {
        var theme;
        theme = _arg.theme;
        return !theme;
      });
      packages.core = packages.core.filter(function(_arg) {
        var theme;
        theme = _arg.theme;
        return !theme;
      });
      return packages;
    };

    InstalledPackagesPanel.prototype.loadPackages = function() {
      this.packageViews = [];
      return this.packageManager.getInstalled().then((function(_this) {
        return function(packages) {
          _this.packages = _this.filterPackages(packages);
          _this.totalPackages.text(_this.packages.user.length + _this.packages.core.length + _this.packages.dev.length);
          _.each(_this.addPackageViews(_this.communityPackages, _this.packages.user), function(v) {
            return _this.packageViews.push(v);
          });
          _this.communityCount.text(_this.packages.user.length);
          _this.packages.core.forEach(function(p) {
            return p.repository != null ? p.repository : p.repository = "https://github.com/atom/" + p.name;
          });
          _.each(_this.addPackageViews(_this.corePackages, _this.packages.core), function(v) {
            return _this.packageViews.push(v);
          });
          _this.coreCount.text(_this.packages.core.length);
          _.each(_this.addPackageViews(_this.devPackages, _this.packages.dev), function(v) {
            return _this.packageViews.push(v);
          });
          return _this.devCount.text(_this.packages.dev.length);
        };
      })(this))["catch"]((function(_this) {
        return function(error) {
          _this.loadingMessage.hide();
          return _this.featuredErrors.append(new ErrorView(_this.packageManager, error));
        };
      })(this));
    };

    InstalledPackagesPanel.prototype.addPackageViews = function(container, packages) {
      var index, pack, packView, packageRow, packageViews, _i, _len;
      container.empty();
      packageViews = [];
      packages.sort(function(left, right) {
        var leftStatus, rightStatus;
        leftStatus = atom.packages.isPackageDisabled(left.name);
        rightStatus = atom.packages.isPackageDisabled(right.name);
        if (leftStatus === rightStatus) {
          return 0;
        } else if (leftStatus > rightStatus) {
          return 1;
        } else {
          return -1;
        }
      });
      for (index = _i = 0, _len = packages.length; _i < _len; index = ++_i) {
        pack = packages[index];
        packageRow = $$(function() {
          return this.div({
            "class": 'row'
          });
        });
        container.append(packageRow);
        packView = new PackageCard(pack, this.packageManager, {
          back: 'Packages'
        });
        packageViews.push(packView);
        packageRow.append(packView);
      }
      return packageViews;
    };

    InstalledPackagesPanel.prototype.filterPackageListByText = function(text) {
      var active;
      if (!this.packages) {
        return;
      }
      active = fuzzaldrin.filter(this.packageViews, text, {
        key: 'filterText'
      });
      _.each(this.packageViews, function(view) {
        return view.hide().addClass('hidden');
      });
      _.each(active, function(view) {
        return view.show().removeClass('hidden');
      });
      this.totalPackages.text("" + active.length + "/" + this.packageViews.length);
      return this.updateSectionCounts();
    };

    InstalledPackagesPanel.prototype.updateSectionCounts = function() {
      var community, core, dev, filterText;
      filterText = this.filterEditor.getModel().getText();
      if (filterText === '') {
        this.totalPackages.text(this.packages.user.length + this.packages.core.length + this.packages.dev.length);
        this.communityCount.text(this.packages.user.length);
        this.coreCount.text(this.packages.core.length);
        return this.devCount.text(this.packages.dev.length);
      } else {
        community = this.communityPackages.find('.package-card:not(.hidden)').length;
        this.communityCount.text("" + community + "/" + this.packages.user.length);
        dev = this.devPackages.find('.package-card:not(.hidden)').length;
        this.devCount.text("" + dev + "/" + this.packages.dev.length);
        core = this.corePackages.find('.package-card:not(.hidden)').length;
        return this.coreCount.text("" + core + "/" + this.packages.core.length);
      }
    };

    InstalledPackagesPanel.prototype.matchPackages = function() {
      var filterText;
      filterText = this.filterEditor.getModel().getText();
      return this.filterPackageListByText(filterText);
    };

    return InstalledPackagesPanel;

  })(View);

}).call(this);
